package ext.form.field {
import ext.Component;
import ext.event.Event;
import ext.form.trigger.Trigger;

[Native("Ext.form.field.Picker", require)]
/**
 * @see ext.form.field.events.PickerEvent.COLLAPSE
 * @eventType ext.form.field.events.PickerEvent.COLLAPSE
 */
[Event(name='onCollapse', type='ext.form.field.events.PickerEvent')]
/**
 * @see ext.form.field.events.PickerEvent.EXPAND
 * @eventType ext.form.field.events.PickerEvent.EXPAND
 */
[Event(name='onExpand', type='ext.form.field.events.PickerEvent')]
/**
 * @see ext.form.field.events.Picker_valueEvent.SELECT
 * @eventType ext.form.field.events.Picker_valueEvent.SELECT
 */
[Event(name='onSelect', type='ext.form.field.events.Picker_valueEvent')]
/**
 * An abstract class for fields that have a single trigger which opens a "picker" popup below
 * the field, e.g. a combobox menu list or a date picker. It provides a base implementation
 * for toggling the picker's visibility when the trigger is clicked, as well as keyboard navigation
 * and some basic events. Sizing and alignment of the picker can be controlled via the
 * →<code>matchFieldWidth</code> and →<code>pickerAlign</code>/→<code>pickerOffset</code> config properties
 * respectively.
 * <p>You would not normally use this class directly, but instead use it as the parent class
 * for a specific picker field implementation. Subclasses must implement the →<code>createPicker()</code>
 * method to create a picker component appropriate for the field.</p>
 * @see #matchFieldWidth
 * @see #pickerAlign
 * @see #pickerOffset
 * @see #createPicker()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html Original Ext JS documentation of 'Ext.form.field.Picker'
 */
public class Picker extends TextField {
  /**
   * @param config @inheritDoc
   */
  public function Picker(config:Picker = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * False to prevent the user from typing text directly into the field; the field can only
   * have its value set via selecting a value from the picker. In this state, the picker
   * can also be opened by clicking directly on the input field itself.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#cfg-editable Original Ext JS documentation of 'editable'
   * @see #getEditable()
   * @see #setEditable()
   */
  override public native function get editable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set editable(value:Boolean):void;

  /**
   * True if the picker is currently expanded, false if not.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#property-isExpanded Original Ext JS documentation of 'isExpanded'
   */
  public native function get isExpanded():Boolean;

  /**
   * @private
   */
  public native function set isExpanded(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Picker Field,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#property-isPickerField Original Ext JS documentation of 'isPickerField'
   */
  public native function get isPickerField():Boolean;

  /**
   * @private
   */
  public native function set isPickerField(value:Boolean):void;

  [ExtConfig]
  /**
   * Whether the picker dropdown's width should be explicitly set to match the width of the field.
   * Defaults to true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#cfg-matchFieldWidth Original Ext JS documentation of 'matchFieldWidth'
   */
  public native function get matchFieldWidth():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set matchFieldWidth(value:Boolean):void;

  [ExtConfig]
  /**
   * A class to be added to the field's →<code>bodyEl</code> element when the picker is opened.
   * @default 'x-pickerfield-open'
   * @see #bodyEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#cfg-openCls Original Ext JS documentation of 'openCls'
   */
  public native function get openCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set openCls(value:String):void;

  [ExtConfig]
  /**
   * The <i>alignment position</i> (→<code>ext.util.Positionable.alignTo()</code>) with which to align the picker.
   * Defaults to "tl-bl?"
   * @default 'tl-bl?'
   * @see ext.util.Positionable#alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#cfg-pickerAlign Original Ext JS documentation of 'pickerAlign'
   */
  public native function get pickerAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pickerAlign(value:String):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  /**
   * An offset [x,y] to use in addition to the →<code>pickerAlign</code> when positioning the picker.
   * Defaults to undefined.
   * @see #pickerAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#cfg-pickerOffset Original Ext JS documentation of 'pickerOffset'
   */
  public native function get pickerOffset():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pickerOffset(value:Array):void;

  [ExtConfig]
  /**
   * An additional CSS class used to style the trigger button. The trigger will always
   * get the class 'x-form-trigger' and triggerCls will be appended if specified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#cfg-triggerCls Original Ext JS documentation of 'triggerCls'
   */
  public native function get triggerCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set triggerCls(value:String):void;

  /**
   * Aligns the picker to the input element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#method-alignPicker Original Ext JS documentation of 'alignPicker'
   */
  protected native function alignPicker():void;

  /**
   * Collapses this field's picker dropdown.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#method-collapse Original Ext JS documentation of 'collapse'
   */
  public native function collapse():void;

  /**
   * Creates and returns the component to be used as this field's picker.
   * Must be implemented by subclasses of Picker.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#method-createPicker Original Ext JS documentation of 'createPicker'
   */
  public native function createPicker():void;

  /**
   * Expands this field's picker dropdown.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#method-expand Original Ext JS documentation of 'expand'
   */
  public native function expand():void;

  /**
   * Returns the value of <code>editable</code>.
   * @see #editable
   */
  override public native function getEditable():Boolean;

  /**
   * Returns a reference to the picker component for this field, creating it if necessary by
   * calling →<code>createPicker()</code>.
   * @return The picker component
   * @see #createPicker()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#method-getPicker Original Ext JS documentation of 'getPicker'
   */
  public native function getPicker():Component;

  /**
   * Handles the trigger click; by default toggles between expanding and collapsing
   * the picker component.
   * @param field This field instance.
   * @param trigger This field's picker trigger.
   * @param e The event that generated this call.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#method-onTriggerClick Original Ext JS documentation of 'onTriggerClick'
   */
  protected native function onTriggerClick(field:Picker, trigger:Trigger, e:Event):void;

  /**
   * Sets the value of <code>editable</code>.
   * @param editable The new value.
   * @see #editable
   */
  override public native function setEditable(editable:Boolean):void;
}
}