package ext.form.field {

[Native("Ext.form.field.Radio", require)]
/**
 * Single radio field. Similar to checkbox, but automatically handles making sure only one radio
 * is checked at a time within a group of radios with the same name.
 * <p><b>Labeling</b></p>
 * <p>In addition to the <i>standard field labeling options</i> (→<code>ext.form.Labelable</code>), radio buttons
 * may be given an optional →<code>boxLabel</code> which will be displayed immediately to the right
 * of the input. Also see →<code>ext.form.RadioGroup</code> for a convenient method of grouping related
 * radio buttons.</p>
 * <p><b>Values</b></p>
 * <p>The main value of a Radio field is a boolean, indicating whether or not the radio is checked.</p>
 * <p>The following values will check the radio:</p>
 * <ul>
 * <li><code>true</code></li>
 * <li><code>'true'</code></li>
 * <li><code>'1'</code></li>
 * <li><code>'on'</code></li>
 * </ul>
 * <p>Any other value will uncheck it.</p>
 * <p>In addition to the main boolean value, you may also specify a separate →<code>inputValue</code>.
 * This will be sent as the parameter value when the form is
 * <i>submitted</i> (→<code>ext.form.BasicForm.submit()</code>). You will want to set this value if you have multiple
 * radio buttons with the same →<code>name</code>, as is almost always the case.</p>
 * <p><b>Example usage</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title      : 'Order Form',
 *     width      : 300,
 *     bodyPadding: 10,
 *     renderTo   : Ext.getBody(),
 *     items: [
 *         {
 *             xtype      : 'fieldcontainer',
 *             fieldLabel : 'Size',
 *             defaultType: 'radiofield',
 *             defaults: {
 *                 flex: 1
 *             },
 *             layout: 'hbox',
 *             items: [
 *                 {
 *                     boxLabel  : 'M',
 *                     name      : 'size',
 *                     inputValue: 'm',
 *                     id        : 'radio1'
 *                 }, {
 *                     boxLabel  : 'L',
 *                     name      : 'size',
 *                     inputValue: 'l',
 *                     id        : 'radio2'
 *                 }, {
 *                     boxLabel  : 'XL',
 *                     name      : 'size',
 *                     inputValue: 'xl',
 *                     id        : 'radio3'
 *                 }
 *             ]
 *         },
 *         {
 *             xtype      : 'fieldcontainer',
 *             fieldLabel : 'Color',
 *             defaultType: 'radiofield',
 *             defaults: {
 *                 flex: 1
 *             },
 *             layout: 'hbox',
 *             items: [
 *                 {
 *                     boxLabel  : 'Blue',
 *                     name      : 'color',
 *                     inputValue: 'blue',
 *                     id        : 'radio4'
 *                 }, {
 *                     boxLabel  : 'Grey',
 *                     name      : 'color',
 *                     inputValue: 'grey',
 *                     id        : 'radio5'
 *                 }, {
 *                     boxLabel  : 'Black',
 *                     name      : 'color',
 *                     inputValue: 'black',
 *                     id        : 'radio6'
 *                 }
 *             ]
 *         }
 *     ],
 *     bbar: [
 *         {
 *             text: 'Smaller Size',
 *             handler: function() {
 *                 var radio1 = Ext.getCmp('radio1'),
 *                     radio2 = Ext.getCmp('radio2'),
 *                     radio3 = Ext.getCmp('radio3');
 *
 *                 //if L is selected, change to M
 *                 if (radio2.getValue()) {
 *                     radio1.setValue(true);
 *                     return;
 *                 }
 *
 *                 //if XL is selected, change to L
 *                 if (radio3.getValue()) {
 *                     radio2.setValue(true);
 *                     return;
 *                 }
 *
 *                 //if nothing is set, set size to S
 *                 radio1.setValue(true);
 *             }
 *         },
 *         {
 *             text: 'Larger Size',
 *             handler: function() {
 *                 var radio1 = Ext.getCmp('radio1'),
 *                     radio2 = Ext.getCmp('radio2'),
 *                     radio3 = Ext.getCmp('radio3');
 *
 *                 //if M is selected, change to L
 *                 if (radio1.getValue()) {
 *                     radio2.setValue(true);
 *                     return;
 *                 }
 *
 *                 //if L is selected, change to XL
 *                 if (radio2.getValue()) {
 *                     radio3.setValue(true);
 *                     return;
 *                 }
 *
 *                 //if nothing is set, set size to XL
 *                 radio3.setValue(true);
 *             }
 *         },
 *         '-',
 *         {
 *             text: 'Select color',
 *             menu: {
 *                 indent: false,
 *                 items: [
 *                     {
 *                         text: 'Blue',
 *                         handler: function() {
 *                             var radio = Ext.getCmp('radio4');
 *                             radio.setValue(true);
 *                         }
 *                     },
 *                     {
 *                         text: 'Grey',
 *                         handler: function() {
 *                             var radio = Ext.getCmp('radio5');
 *                             radio.setValue(true);
 *                         }
 *                     },
 *                     {
 *                         text: 'Black',
 *                         handler: function() {
 *                             var radio = Ext.getCmp('radio6');
 *                             radio.setValue(true);
 *                         }
 *                     }
 *                 ]
 *             }
 *         }
 *     ]
 * });
 * </pre>
 * @see ext.form.Labelable
 * @see #boxLabel
 * @see ext.form.RadioGroup
 * @see #inputValue
 * @see ext.form.BasicForm#submit()
 * @see #name
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html Original Ext JS documentation of 'Ext.form.field.Radio'
 */
public class Radio extends Checkbox {
  /**
   * @param config @inheritDoc
   */
  public function Radio(config:Radio = null) {
    super();
  }

  /**
   * The value <code>true</code> to identify an object as an instance of this or derived class.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html#property-isRadio Original Ext JS documentation of 'isRadio'
   */
  public native function get isRadio():Boolean;

  [ExtConfig]
  /**
   * The value to use for →<code>getModelData()</code> when checked. Uses the →<code>inputValue</code>
   * by default.
   * @default inputValue
   * @since 6.2.1
   * @see #getModelData()
   * @see #inputValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html#cfg-modelValue Original Ext JS documentation of 'modelValue'
   */
  override public native function get modelValue():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set modelValue(value:*):void;

  [ExtConfig]
  /**
   * The value to use for →<code>getModelData()</code> when unchecked.
   * @default null
   * @since 6.2.1
   * @see #getModelData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html#cfg-modelValueUnchecked Original Ext JS documentation of 'modelValueUnchecked'
   */
  override public native function get modelValueUnchecked():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set modelValueUnchecked(value:*):void;

  /**
   * If this radio is part of a group, it will return the selected value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html#method-getGroupValue Original Ext JS documentation of 'getGroupValue'
   */
  public native function getGroupValue():String;

  /**
   * Returns the submit value for the checkbox which can be used when submitting forms.
   * @return True if checked, null if not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html#method-getSubmitValue Original Ext JS documentation of 'getSubmitValue'
   */
  override public native function getSubmitValue():String;

  /**
   * Sets either the checked/unchecked status of this Radio, or, if a string value is passed,
   * checks a sibling Radio of the same name whose value is the value specified.
   * @param value The value to set
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Radio.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;
}
}