package ext.form.field {

[Native("Ext.form.field.Spinner", require)]
/**
 * @see ext.form.field.events.SpinnerField_directionEvent.SPIN
 * @eventType ext.form.field.events.SpinnerField_directionEvent.SPIN
 */
[Event(name='onSpin', type='ext.form.field.events.SpinnerField_directionEvent')]
/**
 * @see ext.form.field.events.SpinnerFieldEvent.SPIN_DOWN
 * @eventType ext.form.field.events.SpinnerFieldEvent.SPIN_DOWN
 */
[Event(name='onSpinDown', type='ext.form.field.events.SpinnerFieldEvent')]
/**
 * @see ext.form.field.events.SpinnerFieldEvent.SPIN_END
 * @eventType ext.form.field.events.SpinnerFieldEvent.SPIN_END
 */
[Event(name='onSpinEnd', type='ext.form.field.events.SpinnerFieldEvent')]
/**
 * @see ext.form.field.events.SpinnerFieldEvent.SPIN_UP
 * @eventType ext.form.field.events.SpinnerFieldEvent.SPIN_UP
 */
[Event(name='onSpinUp', type='ext.form.field.events.SpinnerFieldEvent')]
/**
 * A field with a pair of up/down spinner buttons. This class is not normally instantiated directly,
 * instead it is subclassed and the →<code>onSpinUp()</code> and →<code>onSpinDown()</code> methods
 * are implemented to handle when the buttons are clicked. A good example of this is the
 * →<code>ext.form.field.NumberField</code> field which uses the spinner to increment and decrement
 * the field's value by its →<code>ext.form.field.NumberField.step</code> config value.
 * <p>For example:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('Ext.ux.CustomSpinner', {
 *     extend: 'Ext.form.field.Spinner',
 *     alias: 'widget.customspinner',
 *
 *     // override onSpinUp (using step isn't neccessary)
 *     onSpinUp: function() {
 *         var me = this;
 *         if (!me.readOnly) {
 *             // gets rid of " Pack", defaults to zero on parse failure
 *             var val = parseInt(me.getValue().split(' '), 10) || 0;
 *             me.setValue((val + me.step) + ' Pack');
 *         }
 *     },
 *
 *     // override onSpinDown
 *     onSpinDown: function() {
 *         var me = this;
 *         if (!me.readOnly) {
 *            // gets rid of " Pack", defaults to zero on parse failure
 *            var val = parseInt(me.getValue().split(' '), 10) || 0;
 *            if (val &lt;= me.step) {
 *                me.setValue('Dry!');
 *            } else {
 *                me.setValue((val - me.step) + ' Pack');
 *            }
 *         }
 *     }
 * });
 *
 * Ext.create('Ext.form.FormPanel', {
 *     title: 'Form with SpinnerField',
 *     bodyPadding: 5,
 *     width: 350,
 *     renderTo: Ext.getBody(),
 *     items:[{
 *         xtype: 'customspinner',
 *         fieldLabel: 'How Much Beer?',
 *         step: 6
 *     }]
 * });
 * </pre>
 * <p>By default, pressing the up and down arrow keys will also trigger the onSpinUp and onSpinDown
 * methods; to prevent this, set <code>→keyNavEnabled = false</code>.</p>
 * @see #onSpinUp()
 * @see #onSpinDown()
 * @see ext.form.field.NumberField
 * @see ext.form.field.NumberField#step
 * @see #keyNavEnabled
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html Original Ext JS documentation of 'Ext.form.field.Spinner'
 */
public class SpinnerField extends TextField {
  /**
   * @param config @inheritDoc
   */
  public function SpinnerField(config:SpinnerField = null) {
    super();
  }

  [ExtConfig]
  /**
   * Specifies whether the up and down arrow keys should trigger spinning up and down.
   * Defaults to true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#cfg-keyNavEnabled Original Ext JS documentation of 'keyNavEnabled'
   */
  public native function get keyNavEnabled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyNavEnabled(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether the mouse wheel should trigger spinning up and down while the field
   * has focus.
   * Defaults to true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#cfg-mouseWheelEnabled Original Ext JS documentation of 'mouseWheelEnabled'
   */
  public native function get mouseWheelEnabled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mouseWheelEnabled(value:Boolean):void;

  [ExtConfig]
  /**
   * Whether a <i>click repeater</i> (→<code>ext.util.ClickRepeater</code>) should be attached to the spinner
   * buttons.
   * Defaults to true.
   * @default true
   * @see ext.util.ClickRepeater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#cfg-repeatTriggerClick Original Ext JS documentation of 'repeatTriggerClick'
   */
  override public native function get repeatTriggerClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set repeatTriggerClick(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether the down spinner button is enabled. Defaults to true. To change this after
   * the component is created, use the →<code>setSpinDownEnabled()</code> method.
   * @default true
   * @see #setSpinDownEnabled()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#cfg-spinDownEnabled Original Ext JS documentation of 'spinDownEnabled'
   */
  public native function get spinDownEnabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set spinDownEnabled(value:Boolean):void;

  [ExtConfig]
  /**
   * Specifies whether the up spinner button is enabled. Defaults to true. To change this after
   * the component is created, use the →<code>setSpinUpEnabled()</code> method.
   * @default true
   * @see #setSpinUpEnabled()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#cfg-spinUpEnabled Original Ext JS documentation of 'spinUpEnabled'
   */
  public native function get spinUpEnabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set spinUpEnabled(value:Boolean):void;

  /**
   * This method is called when the spinner down button is clicked, or when the down arrow key
   * is pressed if →<code>keyNavEnabled</code> is true. Must be implemented by subclasses.
   * @see #keyNavEnabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#method-onSpinDown Original Ext JS documentation of 'onSpinDown'
   */
  protected native function onSpinDown():void;

  /**
   * This method is called when the spinner up button is clicked, or when the up arrow key
   * is pressed if →<code>keyNavEnabled</code> is true. Must be implemented by subclasses.
   * @see #keyNavEnabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#method-onSpinUp Original Ext JS documentation of 'onSpinUp'
   */
  protected native function onSpinUp():void;

  /**
   * Sets whether the spinner down button is enabled.
   * @param enabled true to enable the button, false to disable it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#method-setSpinDownEnabled Original Ext JS documentation of 'setSpinDownEnabled'
   */
  public native function setSpinDownEnabled(enabled:Boolean):void;

  /**
   * Sets whether the spinner up button is enabled.
   * @param enabled true to enable the button, false to disable it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#method-setSpinUpEnabled Original Ext JS documentation of 'setSpinUpEnabled'
   */
  public native function setSpinUpEnabled(enabled:Boolean):void;

  /**
   * Triggers the spinner to step down; fires the →<code>event:onSpin</code> and →<code>event:onSpinDown</code> events
   * and calls the →<code>onSpinDown()</code> method. Does nothing if the field is →<code>disabled</code>
   * or if →<code>spinDownEnabled</code> is false.
   * @see #event:onSpin
   * @see #event:onSpinDown
   * @see #onSpinDown()
   * @see #disabled
   * @see #spinDownEnabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#method-spinDown Original Ext JS documentation of 'spinDown'
   */
  public native function spinDown():void;

  /**
   * Triggers the spinner to step up; fires the →<code>event:onSpin</code> and →<code>event:onSpinUp</code> events
   * and calls the →<code>onSpinUp()</code> method. Does nothing if the field is →<code>disabled</code>
   * or if →<code>spinUpEnabled</code> is false.
   * @see #event:onSpin
   * @see #event:onSpinUp
   * @see #onSpinUp()
   * @see #disabled
   * @see #spinUpEnabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#method-spinUp Original Ext JS documentation of 'spinUp'
   */
  public native function spinUp():void;
}
}