package ext.form.field {
import ext.data.Model;

[Native("Ext.form.field.Tag", require)]
/**
 * @see ext.form.field.events.Tag_heightEvent.AUTO_SIZE
 * @eventType ext.form.field.events.Tag_heightEvent.AUTO_SIZE
 */
[Event(name='onAutoSize', type='ext.form.field.events.Tag_heightEvent')]
/**
 * <code>tagfield</code> provides a combobox that removes the hassle of dealing with long and unruly select
 * options. The selected list is visually maintained in the value display area instead of
 * within the picker itself. Users may easily add or remove <code>tags</code> from the
 * display value area.
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *     fields: ['id','show'],
 *     data: [
 *         {id: 0, show: 'Battlestar Galactica'},
 *         {id: 1, show: 'Doctor Who'},
 *         {id: 2, show: 'Farscape'},
 *         {id: 3, show: 'Firefly'},
 *         {id: 4, show: 'Star Trek'},
 *         {id: 5, show: 'Star Wars: Christmas Special'}
 *     ]
 * });
 *
 * Ext.create('Ext.form.Panel', {
 *     renderTo: Ext.getBody(),
 *     title: 'Sci-Fi Television',
 *     height: 200,
 *     width: 500,
 *     items: [{
 *         xtype: 'tagfield',
 *         fieldLabel: 'Select a Show',
 *         store: shows,
 *         displayField: 'show',
 *         valueField: 'id',
 *         queryMode: 'local',
 *         filterPickList: true
 *     }]
 * });
 * </pre>
 * <p><i>History</i></p>
 * <p>Inspired by the SuperBoxSelect component for ExtJS 3,
 * which in turn was inspired by the BoxSelect component for ExtJS 2.</p>
 * <p>Various contributions and suggestions made by many members of the ExtJS community which
 * can be seen in the <a href="http://www.sencha.com/forum/showthread.php?134751-Ext.ux.form.field.BoxSelect">user extension forum post</a>.</p>
 * <p>By: kvee_iv http://www.sencha.com/forum/member.php?29437-kveeiv</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html Original Ext JS documentation of 'Ext.form.field.Tag'
 */
public class Tag extends ComboBox {
  /**
   * @param config @inheritDoc
   */
  public function Tag(config:Tag = null) {
    super();
  }

  [ExtConfig]
  /**
   * Currently unsupported since the value of a tagfield is an array of values and shouldn't
   * ever be a string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-allowOnlyWhitespace Original Ext JS documentation of 'allowOnlyWhitespace'
   */
  override public native function get allowOnlyWhitespace():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set allowOnlyWhitespace(value:Boolean):void;

  [ExtConfig]
  /**
   * Label to be announced to screen reader users
   * when they use Up and Down arrow keys to navigate the list of available values.
   * @default 'Available values'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaAvailableListLabel Original Ext JS documentation of 'ariaAvailableListLabel'
   */
  public native function get ariaAvailableListLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaAvailableListLabel(value:String):void;

  [ExtConfig]
  /**
   * Template text for announcing deselected values to
   * screen reader users. '{0}' will be replaced with the list of values removed from
   * selected list.
   * @default '{0} removed from selection.'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaDeselectedText Original Ext JS documentation of 'ariaDeselectedText'
   */
  public native function get ariaDeselectedText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaDeselectedText(value:String):void;

  /**
   * The name of the Component property that holds
   * a reference to the Element that serves as that Component's ARIA element.
   * This property will be replaced with the actual Element reference after rendering.
   * <p>Most of the simple Components will have their main element as ariaEl.</p>
   * @default 'listWrapper'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#property-ariaEl Original Ext JS documentation of 'ariaEl'
   */
  override public native function get ariaEl():String;

  /**
   * @private
   */
  override public native function set ariaEl(value:String):void;

  [ExtConfig]
  /**
   * The text to be announced by screen readers when input element is
   * focused. This text is used when this component is configured not to allow creating
   * new values; when →<code>createNewOnEnter</code> is set to <code>true</code>, →<code>ariaHelpTextEditable</code>
   * will be used instead.
   * @default 'Use Up and Down arrows to view available values, Enter to select. ' + 'Use Left and Right arrows to view selected values, Delete key to deselect.'
   * @see #createNewOnEnter
   * @see #ariaHelpTextEditable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaHelpText Original Ext JS documentation of 'ariaHelpText'
   */
  public native function get ariaHelpText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaHelpText(value:String):void;

  [ExtConfig]
  /**
   * The text to be announced by screen readers when
   * input element is focused. This text is used when →<code>createNewOnEnter</code> is set to <code>true</code>;
   * see also →<code>ariaHelpText</code>.
   * @default 'Use Up and Down arrows to view available values, Enter to select. ' + 'Type and press Enter to create a new value. ' + 'Use Left and Right arrows to view selected values, ' + 'Delete key to deselect.'
   * @see #createNewOnEnter
   * @see #ariaHelpText
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaHelpTextEditable Original Ext JS documentation of 'ariaHelpTextEditable'
   */
  public native function get ariaHelpTextEditable():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaHelpTextEditable(value:String):void;

  [ExtConfig]
  /**
   * Text to announce to screen reader users when no
   * values are currently selected. This text is used when Tag field is focused.
   * @default 'No value selected.'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaNoneSelectedText Original Ext JS documentation of 'ariaNoneSelectedText'
   */
  public native function get ariaNoneSelectedText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaNoneSelectedText(value:String):void;

  [ExtConfig]
  /**
   * Label to be announced to screen reader users
   * when they use Left and Right arrow keys to navigate the list of currently selected values.
   * @default 'Selected values'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaSelectedListLabel Original Ext JS documentation of 'ariaSelectedListLabel'
   */
  public native function get ariaSelectedListLabel():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaSelectedListLabel(value:String):void;

  [ExtConfig]
  /**
   * Template text for announcing selected values to screen
   * reader users. '{0}' will be replaced with the list of selected values.
   * @default 'Selected {0}.'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-ariaSelectedText Original Ext JS documentation of 'ariaSelectedText'
   */
  public native function get ariaSelectedText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ariaSelectedText(value:String):void;

  [ExtConfig]
  /**
   * Set to <code>false</code> to disable clearing selected values with Backspace key. This mode
   * is recommended for accessible applications.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-clearOnBackspace Original Ext JS documentation of 'clearOnBackspace'
   */
  public native function get clearOnBackspace():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set clearOnBackspace(value:Boolean):void;

  [ExtConfig]
  /**
   * Has no effect if →<code>forceSelection</code> is <code>true</code>.
   * <p>With this set to <code>true</code>, the creation described in
   * →<code>forceSelection</code> will also be triggered when the field loses focus.</p>
   * <p>Please note that this behavior is also affected by the configuration options
   * →<code>autoSelect</code> and →<code>selectOnTab</code>. If those are true and an existing
   * item would have been selected as a result, the partial text the user has entered will
   * be discarded and the existing item will be added to the selection.</p>
   * <p>Setting this option to <code>true</code> is not recommended for accessible applications.</p>
   * @default false
   * @see #forceSelection
   * @see #autoSelect
   * @see #selectOnTab
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-createNewOnBlur Original Ext JS documentation of 'createNewOnBlur'
   */
  public native function get createNewOnBlur():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set createNewOnBlur(value:Boolean):void;

  [ExtConfig]
  /**
   * Has no effect if →<code>forceSelection</code> is <code>true</code>.
   * <p>With this set to <code>true</code>, the creation described in
   * →<code>forceSelection</code> will also be triggered by the 'enter' key.</p>
   * @default false
   * @see #forceSelection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-createNewOnEnter Original Ext JS documentation of 'createNewOnEnter'
   */
  public native function get createNewOnEnter():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set createNewOnEnter(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The character(s) used to separate new values to be added when →<code>createNewOnEnter</code>
   * or →<code>createNewOnBlur</code> are set.
   * <code>→multiSelect = true</code>.
   * @default ','
   * @see #createNewOnEnter
   * @see #createNewOnBlur
   * @see #multiSelect
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-delimiter Original Ext JS documentation of 'delimiter'
   * @see #getDelimiter()
   * @see #setDelimiter()
   */
  override public native function get delimiter():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set delimiter(value:String):void;

  [ExtConfig]
  /**
   * Has no effect if →<code>multiSelect</code> is <code>false</code>.
   * <p>Controls the formatting of the form submit value of the field as returned by
   * →<code>getSubmitValue()</code></p>
   * <ul>
   * <li><code>true</code> for the field value to submit as a json encoded array in a single GET/POST variable</li>
   * <li><code>false</code> for the field to submit as an array of GET/POST variables</li>
   * </ul>
   * @default false
   * @see #multiSelect
   * @see #getSubmitValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-encodeSubmitValue Original Ext JS documentation of 'encodeSubmitValue'
   */
  public native function get encodeSubmitValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set encodeSubmitValue(value:Boolean):void;

  [ExtConfig]
  /**
   * True to hide the currently selected values from the drop down list.
   * <p>Setting this option to <code>true</code> is not recommended for accessible applications.</p>
   * <ul>
   * <li><code>true</code> to hide currently selected values from the drop down pick list</li>
   * <li><code>false</code> to keep the item in the pick list as a selected item</li>
   * </ul>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-filterPickList Original Ext JS documentation of 'filterPickList'
   */
  public native function get filterPickList():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set filterPickList(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to restrict the selected value to one of the values in the list, <code>false</code> to allow
   * the user to set arbitrary text into the field.
   * <p>When →<code>forceSelection</code> is <code>false</code>, new records can be created by the user as they
   * are typed. These records are <b>not</b> added to the combo's store. Multiple new values
   * may be added by separating them with the →<code>delimiter</code>, and can be further configured
   * using the →<code>createNewOnEnter</code> and →<code>createNewOnBlur</code> configuration options.</p>
   * <p>This functionality is primarily useful for things such as an email address.</p>
   * @default true
   * @see #forceSelection
   * @see #delimiter
   * @see #createNewOnEnter
   * @see #createNewOnBlur
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-forceSelection Original Ext JS documentation of 'forceSelection'
   */
  override public native function get forceSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set forceSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> if this field should automatically grow and shrink vertically to its content.
   * Note that this overrides the natural trigger grow functionality, which is used to size
   * the field horizontally.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-grow Original Ext JS documentation of 'grow'
   */
  override public native function get grow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set grow(value:Boolean):void;

  [ExtConfig]
  /**
   * Has no effect if →<code>grow</code> is <code>false</code>.
   * <p>The maximum height to allow when →<code>grow</code> is <code>true</code>, or <code>false</code> to allow for
   * natural vertical growth based on the current selected values. See also →<code>growMin</code>.</p>
   * @default false
   * @see #grow
   * @see #growMin
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-growMax Original Ext JS documentation of 'growMax'
   */
  override public native function get growMax():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set growMax(value:Number):void;

  [ExtConfig]
  /**
   * Has no effect if →<code>grow</code> is <code>false</code>.
   * <p>The minimum height to allow when →<code>grow</code> is <code>true</code>, or <code>false</code> to allow for
   * natural vertical growth based on the current selected values. See also →<code>growMax</code>.</p>
   * @default false
   * @see #grow
   * @see #growMax
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-growMin Original Ext JS documentation of 'growMin'
   */
  override public native function get growMin():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set growMin(value:Number):void;

  [ExtConfig]
  /**
   * Currently unsupported since this is used for horizontal growth and this component
   * only supports vertical growth.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-growToLongestValue Original Ext JS documentation of 'growToLongestValue'
   */
  override public native function get growToLongestValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set growToLongestValue(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.XTemplate</code> to use for the inner
   * markup of the labeled items. Defaults to the configured →<code>displayField</code>
   * @see ext.XTemplate
   * @see #displayField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-labelTpl Original Ext JS documentation of 'labelTpl'
   */
  public native function get labelTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelTpl(value:*):void;

  [ExtConfig]
  /**
   * If set to <code>true</code>, allows the combo field to hold more than one value at a time, and allows
   * selecting multiple items from the dropdown list. The combo's text field will show all
   * selected values using the template defined by →<code>labelTpl</code>.
   * @default true
   * @see #labelTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-multiSelect Original Ext JS documentation of 'multiSelect'
   */
  override public native function get multiSelect():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set multiSelect(value:Boolean):void;

  /**
   * Tells the layout system that the height can be measured immediately because the width
   * does not need setting.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#property-noWrap Original Ext JS documentation of 'noWrap'
   */
  public native function get noWrap():*;

  /**
   * @private
   */
  public native function set noWrap(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to automatically select any existing field text when the field receives input
   * focus. Only applies when →<code>editable</code> = true
   * @default true
   * @see #editable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-selectOnFocus Original Ext JS documentation of 'selectOnFocus'
   */
  override public native function get selectOnFocus():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set selectOnFocus(value:Boolean):void;

  [ExtConfig]
  /**
   * <ul>
   * <li><code>true</code> to have each selected value fill to the width of the form field</li>
   * <li>`false to have each selected value size to its displayed contents</li>
   * </ul>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-stacked Original Ext JS documentation of 'stacked'
   */
  public native function get stacked():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stacked(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.XTemplate</code> to use for the tip of the labeled items.
   * @since 5.1.1
   * @see ext.XTemplate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-tipTpl Original Ext JS documentation of 'tipTpl'
   */
  public native function get tipTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tipTpl(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to activate the trigger when clicking in empty space in the field. Note that the
   * subsequent behavior of this is controlled by the field's →<code>triggerAction</code>.
   * This behavior is similar to that of a basic ComboBox with →<code>editable</code> <code>false</code>.
   * @default true
   * @see #triggerAction
   * @see #editable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-triggerOnClick Original Ext JS documentation of 'triggerOnClick'
   */
  public native function get triggerOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set triggerOnClick(value:Boolean):void;

  [ExtConfig]
  /**
   * The name of the parameter used to load unknown records into the store. If left unspecified,
   * →<code>valueField</code> will be used.
   * @see #valueField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#cfg-valueParam Original Ext JS documentation of 'valueParam'
   */
  public native function get valueParam():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set valueParam(value:String):void;

  /**
   * Track height change to fire →<code>event:onAutoSize</code> event, when applicable.
   * @param width The width that was set
   * @param height The height that was set
   * @param oldWidth The old width, or <code>undefined</code> if this was the initial
   * layout.
   * @param oldHeight The old height, or <code>undefined</code> if this was the initial
   * layout.
   * @see #event:onAutoSize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-afterComponentLayout Original Ext JS documentation of 'afterComponentLayout'
   */
  override protected native function afterComponentLayout(width:Number, height:Number, oldWidth:*, oldHeight:*):void;

  /**
   * Overridden to handle partial-input selections more directly
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-assertValue Original Ext JS documentation of 'assertValue'
   */
  public native function assertValue():void;

  /**
   * Initiate auto-sizing for height based on →<code>grow</code>, if applicable.
   * @see #grow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-autoSize Original Ext JS documentation of 'autoSize'
   */
  override public native function autoSize():void;

  /**
   * Returns the value of <code>delimiter</code>.
   * @see #delimiter
   */
  override public native function getDelimiter():String;

  /**
   * Returns the raw value of the field, without performing any normalization, conversion,
   * or validation. To get a normalized and converted value see →<code>getValue()</code>.
   * Intercept calls to getRawValue to pretend there is no inputEl for rawValue handling,
   * so that we can use inputEl for user input of just the current value.
   * @return value The raw String value of the field
   * @see #getValue()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-getRawValue Original Ext JS documentation of 'getRawValue'
   */
  override public native function getRawValue():String;

  /**
   * Returns the record from valueStore for the labeled item node
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-getRecordByListItemNode Original Ext JS documentation of 'getRecordByListItemNode'
   */
  public native function getRecordByListItemNode(itemEl:*):Model;

  /**
   * Private override to use getSubmitValue() as a convenience
   * Overridden to optionally allow for submitting the field as a json encoded array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-getSubmitData Original Ext JS documentation of 'getSubmitData'
   */
  override public native function getSubmitData():Object;

  /**
   * Returns the records for the field's current value
   * @return The records for the field's current value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-getValueRecords Original Ext JS documentation of 'getValueRecords'
   */
  public native function getValueRecords():Array;

  /**
   * Overridden to be more accepting of varied value types
   * @param value1 The first value to compare
   * @param value2 The second value to compare
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-isEqual Original Ext JS documentation of 'isEqual'
   */
  override public native function isEqual(value1:Object, value2:Object):Boolean;

  /**
   * Intercept calls to onBlur to remove focusCls, because the base field
   * classes assume this should be applied to inputEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-onBlur Original Ext JS documentation of 'onBlur'
   */
  public native function onBlur():void;

  /**
   * Intercept calls to onFocus to add focusCls, because the base field
   * classes assume this should be applied to inputEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-onFocus Original Ext JS documentation of 'onFocus'
   */
  public native function onFocus():void;

  /**
   * Delegation control for selecting and removing labeled items or triggering
   * list collapse/expansion
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-onItemListClick Original Ext JS documentation of 'onItemListClick'
   */
  protected native function onItemListClick(e:*):void;

  /**
   * Handles keyDown processing of key-based selection of labeled items.
   * Supported keyboard controls:
   * <ul>
   * <li>
   * <p>If pick list is expanded</p>
   * <ul>
   * <li><code>CTRL-A</code> will select all the items in the pick list</li>
   * </ul>
   * </li>
   * <li>
   * <p>If the cursor is at the beginning of the input field and there are values present</p>
   * <ul>
   * <li><code>CTRL-A</code> will highlight all the currently selected values</li>
   * <li><code>BACKSPACE</code> and <code>DELETE</code> will remove any currently highlighted selected values</li>
   * <li><code>RIGHT</code> and <code>LEFT</code> will move the current highlight in the appropriate direction</li>
   * <li><code>SHIFT-RIGHT</code> and <code>SHIFT-LEFT</code> will add to the current highlight in the appropriate
   * direction</li>
   * </ul>
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-onKeyDown Original Ext JS documentation of 'onKeyDown'
   */
  protected native function onKeyDown(e:*):void;

  /**
   * Handles auto-selection and creation of labeled items based on this field's
   * delimiter, as well as the keyUp processing of key-based selection of labeled items.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-onKeyUp Original Ext JS documentation of 'onKeyUp'
   */
  protected native function onKeyUp(e:*, t:*):void;

  /**
   * Overridden to get and set the DOM value directly for type-ahead suggestion
   * (bypassing get/setRawValue)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-onTypeAhead Original Ext JS documentation of 'onTypeAhead'
   */
  protected native function onTypeAhead():void;

  /**
   * Removal of labelled item by node reference
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-removeByListItemNode Original Ext JS documentation of 'removeByListItemNode'
   */
  public native function removeByListItemNode(itemEl:*):void;

  /**
   * Removes a value or values from the current value of the field
   * @param value The value or values to remove from the current value,
   * see →<code>setValue()</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-removeValue Original Ext JS documentation of 'removeValue'
   * @see #setValue()
   */
  public native function removeValue(value:*):void;

  /**
   * Intercept calls to renderActiveError to add invalidCls, because the base
   * field classes assume this should be applied to inputEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-renderActiveError Original Ext JS documentation of 'renderActiveError'
   */
  public native function renderActiveError():void;

  /**
   * Sets the value of <code>delimiter</code>.
   * @param delimiter The new value.
   * @see #delimiter
   */
  override public native function setDelimiter(delimiter:String):void;

  /**
   * Sets the specified value(s) into the field. The following value formats are recognized:
   * <ul>
   * <li>
   * <p>Single Values</p>
   * <ul>
   * <li>A string associated to this field's configured →<code>valueField</code></li>
   * <li>A record containing at least this field's configured →<code>valueField</code> and
   * →<code>displayField</code></li>
   * </ul>
   * </li>
   * <li>
   * <p>Multiple Values</p>
   * <ul>
   * <li>If →<code>multiSelect</code> is <code>true</code>, a string containing multiple strings as
   * specified in the Single Values section above, concatenated in to one string
   * with each entry separated by this field's configured →<code>delimiter</code></li>
   * <li>An array of strings as specified in the Single Values section above</li>
   * <li>An array of records as specified in the Single Values section above</li>
   * </ul>
   * </li>
   * </ul>
   * <p>In any of the string formats above, the following occurs if an associated record cannot
   * be found:</p>
   * <ol>
   * <li>If →<code>forceSelection</code> is <code>false</code>, a new record of the →<code>store</code>'s configured
   * model type will be created using the given value as the →<code>displayField</code> and
   * →<code>valueField</code>. This record will be added to the current value, but it will <b>not</b>
   * be added to the store.</li>
   * <li>If →<code>forceSelection</code> is <code>true</code> and →<code>queryMode</code> is <code>remote</code>, the list
   * of unknown values will be submitted as a call to the →<code>store</code>'s load as a parameter
   * named by the →<code>valueParam</code> with values separated by the configured
   * →<code>delimiter</code>.
   * &#42;&#42; This process will cause setValue to asynchronously process. &#42;&#42; This will only be
   * attempted once. Any unknown values that the server does not return records for
   * will be removed.</li>
   * <li>Otherwise, unknown values will be removed.</li>
   * </ol>
   * @param value The value to set
   * @return this, or <code>false</code> if asynchronously querying
   * for unknown values
   * @see #valueField
   * @see #displayField
   * @see #multiSelect
   * @see #delimiter
   * @see #forceSelection
   * @see #store
   * @see #queryMode
   * @see #valueParam
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-setValue Original Ext JS documentation of 'setValue'
   */
  [Return("this")]
  override public native function setValue(value:*):IField;

  /**
   * Toggle of labeled item selection by node reference
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Tag.html#method-toggleSelectionByListItemNode Original Ext JS documentation of 'toggleSelectionByListItemNode'
   */
  public native function toggleSelectionByListItemNode(itemEl:*, keepExisting:*):void;
}
}