package ext.form.field {

[Native("Ext.form.field.TextArea", require)]
/**
 * This class creates a multiline text field, which can be used as a direct replacement
 * for traditional textarea fields. In addition, it supports automatically <i>growing</i> (→<code>grow</code>)
 * the height of the textarea to fit its content.
 * <p>All of the configuration options from →<code>ext.form.field.TextField</code> can be used on TextArea.</p>
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.FormPanel', {
 *     title      : 'Sample TextArea',
 *     width      : 400,
 *     bodyPadding: 10,
 *     renderTo   : Ext.getBody(),
 *     items: [{
 *         xtype     : 'textareafield',
 *         grow      : true,
 *         name      : 'message',
 *         fieldLabel: 'Message',
 *         anchor    : '100%'
 *     }]
 * });
 * </pre>
 * <p>Some other useful configuration options when using →<code>grow</code> are →<code>growMin</code> and
 * →<code>growMax</code>. These allow you to set the minimum and maximum grow heights for the textarea.</p>
 * <p><b>NOTE:</b> In some browsers, carriage returns ('\r', not to be confused with new lines)
 * will be automatically stripped out the value is set to the textarea. Since we cannot
 * use any reasonable method to attempt to re-insert these, they will automatically be
 * stripped out to ensure the behaviour is consistent across browser.</p>
 * @see #grow
 * @see ext.form.field.TextField
 * @see #growMin
 * @see #growMax
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html Original Ext JS documentation of 'Ext.form.field.TextArea'
 */
public class TextArea extends TextField {
  /**
   * @param config @inheritDoc
   */
  public function TextArea(config:TextArea = null) {
    super();
  }

  [ExtConfig]
  /**
   * True if you want the ENTER key to be classed as a special key and the →<code>event:onSpecialKey</code>
   * event to be fired when ENTER is pressed.
   * @default false
   * @see #event:onSpecialKey
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html#cfg-enterIsSpecial Original Ext JS documentation of 'enterIsSpecial'
   */
  public native function get enterIsSpecial():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enterIsSpecial(value:Boolean):void;

  [ExtConfig]
  /**
   * A string that will be appended to the field's current value for the purposes of calculating
   * the target field size. Only used when the →<code>grow</code> config is true. Defaults to a newline
   * for TextArea to ensure there is always a space below the current line.
   * @default '\n-'
   * @see #grow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html#cfg-growAppend Original Ext JS documentation of 'growAppend'
   */
  public native function get growAppend():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set growAppend(value:String):void;

  [ExtConfig]
  /**
   * The maximum height to allow when →<code>grow</code>=true
   * @default 1000
   * @see #grow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html#cfg-growMax Original Ext JS documentation of 'growMax'
   */
  override public native function get growMax():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set growMax(value:Number):void;

  [ExtConfig]
  /**
   * The minimum height to allow when →<code>grow</code>=true
   * @default 60
   * @see #grow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html#cfg-growMin Original Ext JS documentation of 'growMin'
   */
  override public native function get growMin():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set growMin(value:Number):void;

  [ExtConfig]
  /**
   * true to prevent scrollbars from appearing regardless of how much text is in the field.
   * This option is only relevant when →<code>grow</code> is true. Equivalent to setting
   * overflow: hidden.
   * @default false
   * @see #grow
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html#cfg-preventScrollbars Original Ext JS documentation of 'preventScrollbars'
   */
  public native function get preventScrollbars():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set preventScrollbars(value:Boolean):void;

  /**
   * Automatically grows the field to accomodate the height of the text up to the maximum
   * field height allowed. This only takes effect if →<code>grow</code> = true, and fires the
   * →<code>event:onAutoSize</code> event if the height changes.
   * @see #grow
   * @see #event:onAutoSize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.TextArea.html#method-autoSize Original Ext JS documentation of 'autoSize'
   */
  override public native function autoSize():void;
}
}