package ext.form.field {
import ext.data.Model;

[Native("Ext.form.field.Time", require)]
/**
 * Provides a time input field with a time dropdown and automatic time validation.
 * <p>This field recognizes and uses JavaScript Date objects as its main →<code>value</code> type
 * (only the time portion of the date is used; the month/day/year are ignored). In addition,
 * it recognizes string values which are parsed according to the →<code>format</code> and/or
 * →<code>altFormats</code> configs. These may be reconfigured to use time formats appropriate for
 * the user's locale.</p>
 * <p>The field may be limited to a certain range of times by using the →<code>minValue</code> and
 * →<code>maxValue</code> configs, and the interval between time options in the dropdown can be changed
 * with the →<code>increment</code> config.</p>
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.form.Panel', {
 *     title: 'Time Card',
 *     width: 300,
 *     bodyPadding: 10,
 *     renderTo: Ext.getBody(),
 *     items: [{
 *         xtype: 'timefield',
 *         name: 'in',
 *         fieldLabel: 'Time In',
 *         minValue: '6:00 AM',
 *         maxValue: '8:00 PM',
 *         increment: 30,
 *         anchor: '100%'
 *     }, {
 *         xtype: 'timefield',
 *         name: 'out',
 *         fieldLabel: 'Time Out',
 *         minValue: '6:00 AM',
 *         maxValue: '8:00 PM',
 *         increment: 30,
 *         anchor: '100%'
 *    }]
 * });
 * </pre>
 * @see #value
 * @see #format
 * @see #altFormats
 * @see #minValue
 * @see #maxValue
 * @see #increment
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html Original Ext JS documentation of 'Ext.form.field.Time'
 */
public class TimeField extends ComboBox {
  /**
   * @param config @inheritDoc
   */
  public function TimeField(config:TimeField = null) {
    super();
  }

  [ExtConfig]
  /**
   * Multiple date formats separated by "|" to try when parsing a user input value
   * and it doesn't match the defined format.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-altFormats Original Ext JS documentation of 'altFormats'
   */
  public native function get altFormats():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set altFormats(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The underlying <i>data field name</i> (→<code>ext.data.field.DataField.name</code>) to bind to this ComboBox.
   * <p>See also <code>→valueField</code>.</p>
   * @default 'disp'
   * @see ext.data.field.DataField#name
   * @see #valueField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-displayField Original Ext JS documentation of 'displayField'
   * @see #getDisplayField()
   * @see #setDisplayField()
   */
  override public native function get displayField():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set displayField(value:String):void;

  [ExtConfig]
  /**
   * The default time format string which can be overridden for localization support.
   * The format must be valid according to →<code>ext.DateUtil.parse()</code>.
   * <p>Defaults to <code>'g:i A'</code>, e.g., <code>'3:15 PM'</code>. For 24-hour time format try <code>'H:i'</code> instead.</p>
   * @default "g:i A"
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-format Original Ext JS documentation of 'format'
   */
  public native function get format():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set format(value:String):void;

  [ExtConfig]
  /**
   * The format text to be announced by screen readers when the field is focused.
   * @default 'Expected time format HH:MM space AM or PM'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-formatText Original Ext JS documentation of 'formatText'
   */
  override public native function get formatText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set formatText(value:String):void;

  [ExtConfig]
  /**
   * The number of minutes between each time value in the list.
   * <p>Note that this only affects the <i>list of suggested times.</i></p>
   * <p>To enforce that only times on the list are valid, use →<code>snapToIncrement</code>.
   * That will coerce any typed values to the nearest increment point upon blur.</p>
   * @default 15
   * @see #snapToIncrement
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-increment Original Ext JS documentation of 'increment'
   */
  public native function get increment():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set increment(value:Number):void;

  [ExtConfig]
  /**
   * The error text to display when the time in the field is invalid.
   * @default "{0} is not a valid time"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-invalidText Original Ext JS documentation of 'invalidText'
   */
  override public native function get invalidText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set invalidText(value:String):void;

  [ExtConfig]
  /**
   * The error text to display when the entered time is after →<code>maxValue</code>.
   * @default "The time in this field must be equal to or before {0}"
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-maxText Original Ext JS documentation of 'maxText'
   */
  public native function get maxText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxText(value:String):void;

  [ExtConfig]
  /**
   * The maximum allowed time. Can be either a Javascript date object with a valid time value
   * or a string time in a valid format -- see →<code>format</code> and →<code>altFormats</code>.
   * @see #format
   * @see #altFormats
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-maxValue Original Ext JS documentation of 'maxValue'
   * @see #setMaxValue()
   */
  public native function get maxValue():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set maxValue(value:*):void;

  [ExtConfig]
  /**
   * The error text to display when the entered time is before →<code>minValue</code>.
   * @default "The time in this field must be equal to or after {0}"
   * @see #minValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-minText Original Ext JS documentation of 'minText'
   */
  public native function get minText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minText(value:String):void;

  [ExtConfig]
  /**
   * The minimum allowed time. Can be either a Javascript date object with a valid time value
   * or a string time in a valid format -- see →<code>format</code> and →<code>altFormats</code>.
   * @see #format
   * @see #altFormats
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-minValue Original Ext JS documentation of 'minValue'
   * @see #setMinValue()
   */
  public native function get minValue():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set minValue(value:*):void;

  [ExtConfig]
  /**
   * The maximum height of the →<code>ext.picker.TimePicker</code> dropdown.
   * @default 300
   * @see ext.picker.TimePicker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-pickerMaxHeight Original Ext JS documentation of 'pickerMaxHeight'
   */
  public native function get pickerMaxHeight():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set pickerMaxHeight(value:Number):void;

  [ExtConfig]
  /**
   * The mode in which the ComboBox uses the configured Store. Acceptable values are:
   * <ul>
   * <li>
   * <p><b><code>'remote'</code></b> :</p>
   * <p>In <code>queryMode: 'remote'</code>, the ComboBox loads its Store dynamically based upon user
   * interaction.</p>
   * <p>This is typically used for "autocomplete" type inputs, and after the user finishes
   * typing, the Store is →<code>ext.data.Store.load()</code>ed.</p>
   * <p>A parameter containing the typed string is sent in the load request. The default
   * parameter name for the input string is <code>query</code>, but this can be configured using
   * the →<code>queryParam</code> config.</p>
   * <p>In <code>queryMode: 'remote'</code>, the Store may be configured with
   * <code>→ext.data.Store.remoteFilter: true</code>, and further filters may be
   * <i>programatically</i> added to the Store which are then passed with every load
   * request which allows the server to further refine the returned dataset.</p>
   * <p>Typically, in an autocomplete situation, →<code>hideTrigger</code> is configured <code>true</code>
   * because it has no meaning for autocomplete.</p>
   * </li>
   * <li>
   * <p><b><code>'local'</code></b> :</p>
   * <p>ComboBox loads local data</p>
   * <pre>
   * var combo = new Ext.form.field.ComboBox({
   *     renderTo: document.body,
   *     queryMode: 'local',
   *     store: new Ext.data.ArrayStore({
   *         id: 0,
   *         fields: [
   *             'myId',  // numeric value is the key
   *             'displayText'
   *         ],
   *         data: [[1, 'item1'], [2, 'item2']]  // data is local
   *     }),
   *     valueField: 'myId',
   *     displayField: 'displayText',
   *     triggerAction: 'all'
   * });
   * </pre>
   * </li>
   * </ul>
   * @default 'local'
   * @see ext.data.Store#load()
   * @see #queryParam
   * @see ext.data.Store#remoteFilter
   * @see #hideTrigger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-queryMode Original Ext JS documentation of 'queryMode'
   */
  override public native function get queryMode():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set queryMode(value:String):void;

  [ExtConfig]
  /**
   * Whether the Tab key should select the currently highlighted item.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-selectOnTab Original Ext JS documentation of 'selectOnTab'
   */
  override public native function get selectOnTab():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set selectOnTab(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to enforce that only values on the →<code>increment</code> boundary
   * are accepted.
   * <p>Typed values will be coerced to the nearest →<code>increment</code> point on blur.</p>
   * @default false
   * @see #increment
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-snapToIncrement Original Ext JS documentation of 'snapToIncrement'
   */
  public native function get snapToIncrement():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set snapToIncrement(value:Boolean):void;

  [ExtConfig]
  /**
   * The date format string which will be submitted to the server. The format must be valid
   * according to
   * →<code>ext.DateUtil.parse()</code>.
   * <p>Defaults to →<code>format</code>.</p>
   * @default undefined
   * @see ext.SDateUtil#parse() ext.DateUtil.parse()
   * @see #format
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-submitFormat Original Ext JS documentation of 'submitFormat'
   */
  public native function get submitFormat():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set submitFormat(value:String):void;

  [ExtConfig]
  /**
   * An additional CSS class used to style the trigger button. The trigger will always get
   * the →<code>ext.form.trigger.Trigger.baseCls</code> by default and triggerCls will be <b>appended</b>
   * if specified.
   * @default Ext.baseCSSPrefix + 'form-time-trigger'
   * @see ext.form.trigger.Trigger#baseCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-triggerCls Original Ext JS documentation of 'triggerCls'
   */
  override public native function get triggerCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set triggerCls(value:String):void;

  [ExtConfig]
  /**
   * The underlying <i>data value name</i> (→<code>ext.data.field.DataField.name</code>) to bind to this ComboBox.
   * <p><b>Note</b>: use of a <code>→valueField</code> requires the user to make a selection in order for a value
   * to be mapped. See also <code>→displayField</code>.</p>
   * <p>Defaults to match the value of the →<code>displayField</code> config.</p>
   * @default 'date'
   * @see ext.data.field.DataField#name
   * @see #valueField
   * @see #displayField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-valueField Original Ext JS documentation of 'valueField'
   */
  override public native function get valueField():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set valueField(value:String):void;

  [ExtConfig]
  /**
   * The event name(s) to use to publish the →<code>value</code>
   * →<code>ext.form.field.BaseField.bind</code> for this field.
   * @default [
   *     'select',
   *     'blur'
   * ]
   * @see #value
   * @see ext.form.field.BaseField#bind
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#cfg-valuePublishEvent Original Ext JS documentation of 'valuePublishEvent'
   */
  override public native function get valuePublishEvent():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set valuePublishEvent(value:*):void;

  /**
   * Finds the record by searching values in the →<code>valueField</code>.
   * @param value The value to match the field against.
   * @return The matched record or false.
   * @see #valueField
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#method-findRecordByValue Original Ext JS documentation of 'findRecordByValue'
   */
  override public native function findRecordByValue(value:Object):Model;

  /**
   * Returns the value of <code>displayField</code>.
   * @see #displayField
   */
  override public native function getDisplayField():String;

  [ArrayElementType("String")]
  /**
   * Runs all of Time's validations and returns an array of any errors. Note that this first
   * runs Text's validations, so the returned array is an amalgamation of all field errors.
   * The additional validation checks are testing that the time format is valid, that the chosen
   * time is within the →<code>minValue</code> and →<code>maxValue</code> constraints set.
   * @param value The value to get errors for (defaults to the current field value)
   * @return All validation errors for this field
   * @see #minValue
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#method-getErrors Original Ext JS documentation of 'getErrors'
   */
  override public native function getErrors(value:*):Array;

  /**
   * Sets the value of <code>displayField</code>.
   * @param displayField The new value.
   * @see #displayField
   */
  override public native function setDisplayField(displayField:String):void;

  /**
   * Replaces any existing →<code>maxValue</code> with the new time and refreshes the picker's range.
   * @param value The maximum time that can be selected
   * @see #maxValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#method-setMaxValue Original Ext JS documentation of 'setMaxValue'
   */
  public native function setMaxValue(value:*):void;

  /**
   * Replaces any existing →<code>minValue</code> with the new time and refreshes the picker's range.
   * @param value The minimum time that can be selected
   * @see #minValue
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Time.html#method-setMinValue Original Ext JS documentation of 'setMinValue'
   */
  public native function setMinValue(value:*):void;
}
}