package ext.form.field {

[Native("Ext.form.field.VTypes", require)]
/**
 * This is a singleton object which contains a set of commonly used field validation functions
 * and provides a mechanism for creating reusable custom field validations.
 * The following field validation functions are provided out of the box:
 * <ul>
 * <li>→<code>alpha()</code></li>
 * <li>→<code>alphanum()</code></li>
 * <li>→<code>email()</code></li>
 * <li>→<code>url()</code></li>
 * </ul>
 * <p>VTypes can be applied to a <i>Text Field</i> (→<code>ext.form.field.TextField</code>) using the
 * <code>→ext.form.field.TextField.vtype</code> configuration:</p>
 * <pre>
 * Ext.create('Ext.form.field.Text', {
 *     fieldLabel: 'Email Address',
 *     name: 'email',
 *     vtype: 'email' // applies email validation rules to this field
 * });
 * </pre>
 * <p>To create custom VTypes:</p>
 * <pre>
 * // custom Vtype for vtype:'time'
 * Ext.define('Override.form.field.VTypes', {
 *     override: 'Ext.form.field.VTypes',
 *
 *     // vtype validation function
 *     time: function(value) {
 *         return this.timeRe.test(value);
 *     },
 *     // RegExp for the value to be tested against within the validation function
 *     timeRe: /^([1-9]|1[0-9]):([0-5][0-9])(\s[a|p]m)$/i,
 *     // vtype Text property: The error text to display when the validation function
 *     // returns false
 *     timeText: 'Not a valid time.  Must be in the format "12:34 PM".',
 *     // vtype Mask property: The keystroke filter mask
 *     timeMask: /[\d\s:amp]/i
 * });
 * </pre>
 * <p>In the above example the <code>time</code> function is the validator that will run when field validation
 * occurs, <code>timeText</code> is the error message, and <code>timeMask</code> limits what characters can be typed
 * into the field. Note that the <code>Text</code> and <code>Mask</code> functions must begin with the same name
 * as the validator function.</p>
 * <p>Using a custom validator is the same as using one of the build-in validators - just use the name
 * of the validator function as the <code>→ext.form.field.TextField.vtype</code> configuration on a
 * <i>Text Field</i> (→<code>ext.form.field.TextField</code>):</p>
 * <pre>
 * Ext.create('Ext.form.field.Text', {
 *     fieldLabel: 'Departure Time',
 *     name: 'departureTime',
 *     vtype: 'time' // applies custom time validation rules to this field
 * });
 * </pre>
 * <p>Another example of a custom validator:</p>
 * <pre>
 * // custom Vtype for vtype:'IPAddress'
 * Ext.define('Override.form.field.VTypes', {
 *     override: 'Ext.form.field.VTypes',
 *
 *     IPAddress:  function(value) {
 *         return this.IPAddressRe.test(value);
 *     },
 *     IPAddressRe: /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,
 *     IPAddressText: 'Must be a numeric IP address',
 *     IPAddressMask: /[\d\.]/i
 * });
 * </pre>
 * <p>It's important to note that using →<code>ext.Ext.define()</code> with the
 * →<code>ext.ExtClass.override_</code> property means that the custom validator function as well as
 * <code>Text</code> and <code>Mask</code> fields are added as properties of the <code>→ext.form.field.VTypes</code> singleton.</p>
 * @see SVTypes#alpha()
 * @see SVTypes#alphanum()
 * @see SVTypes#email()
 * @see SVTypes#url()
 * @see ext.form.field.TextField
 * @see ext.form.field.TextField#vtype
 * @see ext.SExt#define() ext.Ext.define()
 * @see ext.ExtClass#override_
 * @see ext.form.field.#VTypes ext.form.field.VTypes
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.VTypes.html Original Ext JS documentation of 'Ext.form.field.VTypes'
 */
public const VTypes:SVTypes = new SVTypes;
}