package ext.form.field.events {
import ext.form.field.Field;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.BaseField_isDirtyEvent")]
public class BaseField_isDirtyEvent extends FlExtEvent {
  /**
   * Fires when a change in the field's →<code>isDirty()</code> state is detected.
   * @see ext.form.field.BaseField#isDirty()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Field.html#event-dirtychange Original Ext JS documentation of 'dirtychange'
   * @see ext.form.field.BaseField
   * @eventType onDirtyChange
   */
  public static const DIRTY_CHANGE:String = "onDirtyChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "isDirty", "eOpts"];

  public function BaseField_isDirtyEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Whether or not the field is now dirty
   */
  public native function get isDirty():Boolean;

  public native function get source():Field;
}
}