package ext.form.field.events {
import ext.form.field.FileUploadField;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.FileUploadField_valueEvent")]
public class FileUploadField_valueEvent extends FlExtEvent {
  /**
   * Fires when the underlying file input field's value has changed from the user selecting
   * a new file from the system file selection dialog.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.File.html#event-change Original Ext JS documentation of 'change'
   * @see ext.form.field.FileUploadField
   * @eventType onChange
   */
  public static const CHANGE:String = "onChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "value", "eOpts"];

  public function FileUploadField_valueEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():FileUploadField;

  /**
   * The file value returned by the underlying file input field
   */
  public native function get value():String;
}
}