package ext.form.field.events {
import ext.form.field.HtmlEditor;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.HtmlEditorEvent")]
public class HtmlEditorEvent extends FlExtEvent {
  /**
   * Fires when the editor is first receives the focus. Any insertion must wait until after
   * this event.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#event-activate Original Ext JS documentation of 'activate'
   * @see ext.form.field.HtmlEditor
   * @eventType onActivate
   */
  public static const ACTIVATE:String = "onActivate";
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#event-blur Original Ext JS documentation of 'blur'
   * @see ext.form.field.HtmlEditor
   * @eventType onBlur
   */
  public static const BLUR:String = "onBlur";
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#event-focus Original Ext JS documentation of 'focus'
   * @see ext.form.field.HtmlEditor
   * @eventType onFocus
   */
  public static const FOCUS:String = "onFocus";
  /**
   * Fires when the editor is fully initialized (including the iframe)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#event-initialize Original Ext JS documentation of 'initialize'
   * @see ext.form.field.HtmlEditor
   * @eventType onInitialize
   */
  public static const INITIALIZE:String = "onInitialize";
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.HtmlEditor.html#event-specialkey Original Ext JS documentation of 'specialkey'
   * @see ext.form.field.HtmlEditor
   * @eventType onSpecialKey
   */
  public static const SPECIAL_KEY:String = "onSpecialKey";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function HtmlEditorEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():HtmlEditor;
}
}