package ext.form.field.events {
import ext.form.field.Picker;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.PickerEvent")]
public class PickerEvent extends FlExtEvent {
  /**
   * Fires when the field's picker is collapsed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#event-collapse Original Ext JS documentation of 'collapse'
   * @see ext.form.field.Picker
   * @eventType onCollapse
   */
  public static const COLLAPSE:String = "onCollapse";
  /**
   * Fires when the field's picker is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Picker.html#event-expand Original Ext JS documentation of 'expand'
   * @see ext.form.field.Picker
   * @eventType onExpand
   */
  public static const EXPAND:String = "onExpand";
  public static const __PARAMETER_SEQUENCE__:Array = ["field", "eOpts"];

  public function PickerEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * This field instance
   */
  public native function get field():Picker;
}
}