package ext.form.field.events {
import ext.form.field.SpinnerField;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.SpinnerField_directionEvent")]
public class SpinnerField_directionEvent extends FlExtEvent {
  /**
   * Fires when the spinner is made to spin up or down.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Spinner.html#event-spin Original Ext JS documentation of 'spin'
   * @see ext.form.field.SpinnerField
   * @eventType onSpin
   */
  public static const SPIN:String = "onSpin";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "direction", "eOpts"];

  public function SpinnerField_directionEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * Either 'up' if spinning up, or 'down' if spinning down.
   */
  public native function get direction():String;

  public native function get source():SpinnerField;
}
}