package ext.form.field.events {
import ext.event.Event;
import ext.form.field.TextField;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.TextField_eEvent")]
public class TextField_eEvent extends FlExtEvent {
  /**
   * Keypress input field event. This event only fires if <b>→<code>enableKeyEvents</code></b>
   * is set to true.
   * @see ext.form.field.TextField#enableKeyEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Text.html#event-keypress Original Ext JS documentation of 'keypress'
   * @see ext.form.field.TextField
   * @eventType onKeypress
   */
  public static const KEYPRESS:String = "onKeypress";
  /**
   * Keydown input field event. This event only fires if <b>→<code>enableKeyEvents</code></b>
   * is set to true.
   * @see ext.form.field.TextField#enableKeyEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Text.html#event-keydown Original Ext JS documentation of 'keydown'
   * @see ext.form.field.TextField
   * @eventType onKeyDown
   */
  public static const KEY_DOWN:String = "onKeyDown";
  /**
   * Keyup input field event. This event only fires if <b>→<code>enableKeyEvents</code></b>
   * is set to true.
   * @see ext.form.field.TextField#enableKeyEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Text.html#event-keyup Original Ext JS documentation of 'keyup'
   * @see ext.form.field.TextField
   * @eventType onKeyUp
   */
  public static const KEY_UP:String = "onKeyUp";
  /**
   * Fires when this field is pasted. This event only fires if <b>→<code>enableKeyEvents</code></b>
   * is set to true.
   * @see ext.form.field.TextField#enableKeyEvents
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Text.html#event-paste Original Ext JS documentation of 'paste'
   * @see ext.form.field.TextField
   * @eventType onPaste
   */
  public static const PASTE:String = "onPaste";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "e", "eOpts"];

  public function TextField_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get e():Event;

  /**
   * This text field
   */
  public native function get source():TextField;
}
}