package ext.form.field.events {
import ext.form.field.TextField;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.form.field.events.TextField_widthEvent")]
public class TextField_widthEvent extends FlExtEvent {
  /**
   * Fires when the <b>→<code>autoSize()</code></b> function is triggered and the field is resized
   * according to the →<code>grow</code>/→<code>growMin</code>/→<code>growMax</code> configs as a result.
   * This event provides a hook for the developer to apply additional logic at runtime
   * to resize the field if needed.
   * @see ext.form.field.TextField#autoSize()
   * @see ext.form.field.TextField#grow
   * @see ext.form.field.TextField#growMin
   * @see ext.form.field.TextField#growMax
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.field.Text.html#event-autosize Original Ext JS documentation of 'autosize'
   * @see ext.form.field.TextField
   * @eventType onAutoSize
   */
  public static const AUTO_SIZE:String = "onAutoSize";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "width", "eOpts"];

  public function TextField_widthEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * This text field
   */
  public native function get source():TextField;

  /**
   * The new field width
   */
  public native function get width():Number;
}
}