package ext.form.trigger {

[Native("Ext.form.trigger.Spinner", require)]
/**
 * A Trigger that contains 2 clickable elements inside in the form of a "up" and a "down"
 * trigger.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Spinner.html Original Ext JS documentation of 'Ext.form.trigger.Spinner'
 */
public class SpinnerTrigger extends Trigger {
  /**
   * @param config @inheritDoc
   */
  public function SpinnerTrigger(config:SpinnerTrigger = null) {
    super();
  }

  [ExtConfig]
  /**
   * The handler for the 'down' button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Spinner.html#cfg-downHandler Original Ext JS documentation of 'downHandler'
   */
  public native function get downHandler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set downHandler(value:*):void;

  [ExtConfig]
  /**
   * The handler for the 'up' button
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Spinner.html#cfg-upHandler Original Ext JS documentation of 'upHandler'
   */
  public native function get upHandler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set upHandler(value:*):void;

  [ExtConfig]
  /**
   * True to layout the spinner in a vertical format.
   * <p><b>Note:</b> This is not intended to be configured on an instance level, but is
   * meant to be overridden by mobile-friendly themes that provide styling for
   * vertically oriented triggers.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Spinner.html#cfg-vertical Original Ext JS documentation of 'vertical'
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;
}
}