package ext.form.trigger {
import ext.Base;
import ext.dom.Element;
import ext.mixin.IFactoryable;

[Native("Ext.form.trigger.Trigger", require)]
/**
 * Base class for <i>Text Field triggers</i> (→<code>ext.form.field.TextField.triggers</code>)
 * @see ext.form.field.TextField#triggers
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html Original Ext JS documentation of 'Ext.form.trigger.Trigger'
 */
public class Trigger extends Base implements IFactoryable {
  /**
   * @param config @inheritDoc
   */
  public function Trigger(config:Trigger = null) {
    super();
  }

  /**
   * An optional template for rendering child elements inside the trigger element.
   * Useful for creating more complex triggers such as →<code>ext.form.trigger.SpinnerTrigger</code>.
   * @see ext.form.trigger.SpinnerTrigger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#property-bodyTpl Original Ext JS documentation of 'bodyTpl'
   */
  public native function get bodyTpl():*;

  /**
   * @private
   */
  public native function set bodyTpl(value:*):void;

  [ExtConfig]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-cls Original Ext JS documentation of 'cls'
   */
  public native function get cls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cls(value:String):void;

  [ExtConfig]
  /**
   * An additional CSS class (or classes) to be added to the trigger's element. Can
   * be a single class name (e.g. 'foo') or a space-separated list of class names
   * (e.g. 'foo bar').
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-extraCls Original Ext JS documentation of 'extraCls'
   */
  public native function get extraCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set extraCls(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  /**
   * Function to run when trigger is clicked or tapped.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * <code>true</code> to initially render the trigger hidden.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-hidden Original Ext JS documentation of 'hidden'
   */
  public native function get hidden():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * Set 'false' to prevent trigger from being hidden even though the related field is
   * set →<code>ext.form.field.TextField.readOnly</code>
   * @default true
   * @see ext.form.field.TextField#readOnly
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-hideOnReadOnly Original Ext JS documentation of 'hideOnReadOnly'
   */
  public native function get hideOnReadOnly():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideOnReadOnly(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to attach a <i>click repeater</i> (→<code>ext.util.ClickRepeater</code>) to the trigger
   * @default false
   * @see ext.util.ClickRepeater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-repeatClick Original Ext JS documentation of 'repeatClick'
   */
  public native function get repeatClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set repeatClick(value:Boolean):void;

  [ExtConfig]
  /**
   * Execution context for the →<code>handler</code> function.
   * @see #handler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * The triggers tooltip text. This text is available when using <code>→ext.tip.QuickTipManager</code>.
   * @since 6.2.0
   * @see ext.tip.#QuickTipManager ext.tip.QuickTipManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   */
  public native function get tooltip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set tooltip(value:String):void;

  [ExtConfig]
  /**
   * An optional weighting to change the ordering of the items. The default weight is
   * <code>0</code>. Triggers are sorted by weight in ascending order before being rendered.
   * The value may be a negative value in order to position custom triggers ahead of
   * default triggers like that of ComboBox.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-weight Original Ext JS documentation of 'weight'
   */
  public native function get weight():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set weight(value:Number):void;

  [ExtConfig]
  /**
   * The trigger's width, in pixels. Typically this is not needed
   * as the trigger width is normally determined by the style sheet, (see
   * <i>extjs-text-field</i> (→<code>ext.form.field.TextField.style:$form-trigger-width</code>) or
   * →<code>ext.form.field.TextField.style:$extjs-text-field-ui</code>).
   * @see ext.form.field.TextField#style:$form-trigger-width
   * @see ext.form.field.TextField#style:$extjs-text-field-ui
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#cfg-width Original Ext JS documentation of 'width'
   */
  public native function get width():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set width(value:Number):void;

  /**
   * Called when this trigger's field is rendered
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-afterFieldRender Original Ext JS documentation of 'afterFieldRender'
   */
  protected native function afterFieldRender():void;

  /**
   * Allows addition of data to the render data object for the →<code>bodyTpl</code>.
   * @see #bodyTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-getBodyRenderData Original Ext JS documentation of 'getBodyRenderData'
   */
  protected native function getBodyRenderData():Object;

  /**
   * Get the element for this trigger.
   * @return The element for this trigger, <code>null</code> if not rendered.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-getEl Original Ext JS documentation of 'getEl'
   */
  public native function getEl():Element;

  /**
   * Returns the element that should receive the "state" classes - →<code>focusCls</code>,
   * →<code>overCls</code>, and →<code>clickCls</code>.
   * @see #focusCls
   * @see #overCls
   * @see #clickCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-getStateEl Original Ext JS documentation of 'getStateEl'
   */
  protected native function getStateEl():Element;

  /**
   * Hides the trigger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-hide Original Ext JS documentation of 'hide'
   */
  public native function hide():void;

  /**
   * Returns <code>true</code> if this Trigger is visible.
   * @since 5.0.0
   * @return <code>true</code> if this trigger is visible, <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-isVisible Original Ext JS documentation of 'isVisible'
   */
  public native function isVisible():Boolean;

  /**
   * Handles a click on the trigger's element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-onClick Original Ext JS documentation of 'onClick'
   */
  protected native function onClick():void;

  /**
   * Called when this trigger's field is blurred
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-onFieldBlur Original Ext JS documentation of 'onFieldBlur'
   */
  protected native function onFieldBlur():void;

  /**
   * Called when this trigger's field is focused
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-onFieldFocus Original Ext JS documentation of 'onFieldFocus'
   */
  protected native function onFieldFocus():void;

  /**
   * Called when this trigger's field is rendered
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-onFieldRender Original Ext JS documentation of 'onFieldRender'
   */
  protected native function onFieldRender():void;

  /**
   * Shows the trigger
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.form.trigger.Trigger.html#method-show Original Ext JS documentation of 'show'
   */
  public native function show():void;
}
}