package ext.fx {
import ext.mixin.Observable;

[Native("Ext.fx.Anim", require)]
/**
 * @see ext.fx.events.Anim_startTimeEvent.AFTER_ANIMATE
 * @eventType ext.fx.events.Anim_startTimeEvent.AFTER_ANIMATE
 */
[Event(name='onAfterAnimate', type='ext.fx.events.Anim_startTimeEvent')]
/**
 * @see ext.fx.events.AnimEvent.BEFORE_ANIMATE
 * @eventType ext.fx.events.AnimEvent.BEFORE_ANIMATE
 */
[Event(name='onBeforeAnimate', type='ext.fx.events.AnimEvent')]
/**
 * @see ext.fx.events.Anim_startTimeEvent.LAST_FRAME
 * @eventType ext.fx.events.Anim_startTimeEvent.LAST_FRAME
 */
[Event(name='onLastFrame', type='ext.fx.events.Anim_startTimeEvent')]
/**
 * This class manages animation for a specific →<code>target</code>. The animation allows
 * animation of various properties on the target, such as size, position, color and others.
 * <p><b><i>Starting Conditions</i></b></p>
 * <p>The starting conditions for the animation are provided by the →<code>from</code> configuration.
 * Any/all of the properties in the →<code>from</code> configuration can be specified. If a particular
 * property is not defined, the starting value for that property will be read directly from the
 * target.</p>
 * <p><b><i>End Conditions</i></b></p>
 * <p>The ending conditions for the animation are provided by the →<code>to</code> configuration. These mark
 * the final values once the animations has finished. The values in the →<code>from</code> can mirror
 * those in the →<code>to</code> configuration to provide a starting point.</p>
 * <p><b><i>Other Options</i></b></p>
 * <ul>
 * <li>→<code>duration</code>: Specifies the time period of the animation.</li>
 * <li>→<code>easing</code>: Specifies the easing of the animation.</li>
 * <li>→<code>iterations</code>: Allows the animation to repeat a number of times.</li>
 * <li>→<code>alternate</code>: Used in conjunction with →<code>iterations</code>, reverses the direction
 * every second iteration.</li>
 * </ul>
 * <p><b><i>Example Code</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * var myComponent = Ext.create('Ext.Component', {
 *     renderTo: document.body,
 *     width: 200,
 *     height: 200,
 *     style: 'border: 1px solid red;'
 * });
 *
 * Ext.create('Ext.fx.Anim', {
 *     target: myComponent,
 *     duration: 1000,
 *     from: {
 *         width: 400 //starting width 400
 *     },
 *     to: {
 *         width: 300, //end width 300
 *         height: 300 // end height 300
 *     }
 * });
 * </pre>
 * @see #target
 * @see #from
 * @see #to
 * @see #duration
 * @see #easing
 * @see #iterations
 * @see #alternate
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html Original Ext JS documentation of 'Ext.fx.Anim'
 */
public class Anim extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function Anim(config:Anim = null) {
    super();
  }

  [ExtConfig]
  /**
   * Used in conjunction with iterations to reverse the animation each time an iteration
   * completes.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-alternate Original Ext JS documentation of 'alternate'
   */
  public native function get alternate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set alternate(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to immediately force this animation to its final state. This can be useful
   * in cases where you want the final effect of an animation, but need to the actual
   * animation dynamically. Also see the →<code>jumpToEnd()</code> method.
   * @default false
   * @see #jumpToEnd()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-autoEnd Original Ext JS documentation of 'autoEnd'
   */
  public native function get autoEnd():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoEnd(value:Boolean):void;

  [ExtConfig]
  /**
   * A function to be run after the animation has completed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-callback Original Ext JS documentation of 'callback'
   */
  public native function get callback():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set callback(value:*):void;

  /**
   * Current iteration the animation is running.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#property-currentIteration Original Ext JS documentation of 'currentIteration'
   */
  public native function get currentIteration():Number;

  /**
   * @private
   */
  public native function set currentIteration(value:Number):void;

  [ExtConfig]
  /**
   * Time to delay before starting the animation.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-delay Original Ext JS documentation of 'delay'
   */
  public native function get delay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delay(value:Number):void;

  [ExtConfig]
  /**
   * Time in milliseconds for a single animation to last. If the →<code>iterations</code> property is
   * specified, then each animate will take the same duration for each iteration.
   * @default 250
   * @see #iterations
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-duration Original Ext JS documentation of 'duration'
   */
  public native function get duration():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set duration(value:Number):void;

  [ExtConfig]
  /**
   * Currently only for Component Animation: Only set a component's outer element size bypassing
   * layouts. Set to true to do full layouts for every frame of the animation.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-dynamic Original Ext JS documentation of 'dynamic'
   */
  public native function get dynamic():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dynamic(value:Boolean):void;

  [ExtConfig]
  /**
   * This describes how the intermediate values used during a transition will be calculated.
   * It allows for a transition to change speed over its duration.
   * <ul>
   * <li>backIn</li>
   * <li>backOut</li>
   * <li>bounceIn</li>
   * <li>bounceOut</li>
   * <li>ease</li>
   * <li>easeIn</li>
   * <li>easeOut</li>
   * <li>easeInOut</li>
   * <li>elasticIn</li>
   * <li>elasticOut</li>
   * <li>cubic-bezier(x1, y1, x2, y2)</li>
   * </ul>
   * <p>Note that cubic-bezier will create a custom easing curve following the CSS3
   * <a href="http://www.w3.org/TR/css3-transitions/#transition-timing-function_tag">transition-timing-function</a> specification. The four values specify points P1 and P2
   * of the curve as (x1, y1, x2, y2). All values must be in the range [0, 1] or the definition
   * is invalid.</p>
   * @default 'ease'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-easing Original Ext JS documentation of 'easing'
   */
  public native function get easing():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set easing(value:String):void;

  [ExtConfig]
  /**
   * An object containing property/value pairs for the beginning of the animation.
   * If not specified, the current state of the Ext.fx.target will be used. For example:
   * <pre>
   * from: {
   *     opacity: 0,       // Transparent
   *     color: '#ffffff', // White
   *     left: 0
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-from Original Ext JS documentation of 'from'
   */
  public native function get from():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set from(value:Object):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Anim, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#property-isAnimation Original Ext JS documentation of 'isAnimation'
   */
  public native function get isAnimation():Boolean;

  /**
   * @private
   */
  public native function set isAnimation(value:Boolean):void;

  [ExtConfig]
  /**
   * Number of times to execute the animation.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-iterations Original Ext JS documentation of 'iterations'
   */
  public native function get iterations():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set iterations(value:Number):void;

  [ExtConfig]
  /**
   * Animation keyframes follow the CSS3 Animation configuration pattern. 'from' is always
   * considered '0%' and 'to' is considered '100%'. <b>Every keyframe declaration must have
   * a keyframe rule for 0% and 100%, possibly defined using "from" or "to".</b> A keyframe
   * declaration without these keyframe selectors is invalid and will not be available for
   * animation. The keyframe declaration for a keyframe rule consists of properties and values.
   * Properties that are unable to be animated are ignored in these rules, with the exception of
   * 'easing' which can be changed at each keyframe. For example:
   * <pre>
   * keyframes : {
   *     '0%': {
   *         left: 100
   *     },
   *     '40%': {
   *         left: 150
   *     },
   *     '60%': {
   *         left: 75
   *     },
   *     '100%': {
   *         left: 100
   *     }
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-keyframes Original Ext JS documentation of 'keyframes'
   */
  public native function get keyframes():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyframes(value:Object):void;

  /**
   * Flag to determine if the animation is paused. Only set this to true if you need to
   * keep the Anim instance around to be un-paused later; otherwise call →<code>end()</code>.
   * @default false
   * @see #end()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#property-paused Original Ext JS documentation of 'paused'
   */
  public native function get paused():Boolean;

  /**
   * @private
   */
  public native function set paused(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to remove the target when the animation is complete, using the appropriate removal
   * method for the target. For example, a component will be destroyed, elements will be removed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-remove Original Ext JS documentation of 'remove'
   */
  public native function get remove():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set remove(value:Boolean):void;

  [ExtConfig]
  /**
   * Run the animation from the end to the beginning
   * Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-reverse Original Ext JS documentation of 'reverse'
   */
  public native function get reverse():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set reverse(value:Boolean):void;

  /**
   * Flag to determine if the animation has started
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#property-running Original Ext JS documentation of 'running'
   */
  public native function get running():Boolean;

  /**
   * @private
   */
  public native function set running(value:Boolean):void;

  [ExtConfig]
  /**
   * The scope that the →<code>callback</code> function will be called with
   * @see #callback
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set scope(value:Object):void;

  /**
   * Starting time of the animation.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#property-startTime Original Ext JS documentation of 'startTime'
   */
  public native function get startTime():Date;

  /**
   * @private
   */
  public native function set startTime(value:Date):void;

  [ExtConfig]
  /**
   * The →<code>ext.fx.target.Target</code> to apply the animation to. This should only be specified
   * when creating an Ext.fx.Anim directly. The target does not need to be a
   * →<code>ext.fx.target.Target</code> instance, it can be the underlying object. For example, you can
   * pass a Component, Element or Sprite as the target and the Anim will create the appropriate
   * →<code>ext.fx.target.Target</code> object automatically.
   * @see ext.fx.target.Target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-target Original Ext JS documentation of 'target'
   */
  public native function get target():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:*):void;

  [ExtConfig]
  /**
   * <b>This is a required setting</b>. An object containing property/value pairs for the end of the animation. For example:
   * <pre>
   * to: {
   *     opacity: 1,       // Opaque
   *     color: '#00ff00', // Green
   *     left: 500
   * }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#cfg-to Original Ext JS documentation of 'to'
   */
  public native function get to():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set to(value:Object):void;

  /**
   * Fire afteranimate event and end the animation. Usually called automatically when the
   * animation reaches its final frame, but can also be called manually to preemptively
   * stop and destroy the running animation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#method-end Original Ext JS documentation of 'end'
   */
  public native function end(suppressEvent:* = undefined):void;

  /**
   * Immediately force this animation to its final state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#method-jumpToEnd Original Ext JS documentation of 'jumpToEnd'
   */
  public native function jumpToEnd(suppressEvent:*):void;
}
}