package ext.fx {
import ext.fx.target.Target;
import ext.mixin.Observable;

[Native("Ext.fx.Animator", require)]
/**
 * @see ext.fx.events.Animator_startTimeEvent.AFTER_ANIMATE
 * @eventType ext.fx.events.Animator_startTimeEvent.AFTER_ANIMATE
 */
[Event(name='onAfterAnimate', type='ext.fx.events.Animator_startTimeEvent')]
/**
 * @see ext.fx.events.AnimatorEvent.BEFORE_ANIMATE
 * @eventType ext.fx.events.AnimatorEvent.BEFORE_ANIMATE
 */
[Event(name='onBeforeAnimate', type='ext.fx.events.AnimatorEvent')]
/**
 * @see ext.fx.events.Animator_keyframeEvent.KEYFRAME
 * @eventType ext.fx.events.Animator_keyframeEvent.KEYFRAME
 */
[Event(name='onKeyframe', type='ext.fx.events.Animator_keyframeEvent')]
/**
 * This class is used to run keyframe based animations, which follows the CSS3 based animation
 * structure. Keyframe animations differ from typical from/to animations in that they offer
 * the ability to specify values at various points throughout the animation.
 * <p><b><i>Using Keyframes</i></b></p>
 * <p>The →<code>keyframes</code> option is the most important part of specifying an animation when using
 * this class. A key frame is a point in a particular animation. We represent this as a percentage
 * of the total animation duration. At each key frame, we can specify the target values at that
 * time. Note that you <i>must</i> specify the values at 0% and 100%, the start and ending values.
 * There is also a →<code>event:onKeyframe</code> event that fires after each key frame is reached.</p>
 * <p><b><i>Example</i></b></p>
 * <p>In the example below, we modify the values of the element at each fifth throughout the animation.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.fx.Animator', {
 *     target: Ext.getBody().createChild({
 *         style: {
 *             width: '100px',
 *             height: '100px',
 *             'background-color': 'red'
 *         }
 *     }),
 *     duration: 10000, // 10 seconds
 *     keyframes: {
 *         0: {
 *             opacity: 1,
 *             backgroundColor: 'FF0000'
 *         },
 *         20: {
 *             x: 30,
 *             opacity: 0.5
 *         },
 *         40: {
 *             x: 130,
 *             backgroundColor: '0000FF'
 *         },
 *         60: {
 *             y: 80,
 *             opacity: 0.3
 *         },
 *         80: {
 *             width: 200,
 *             y: 200
 *         },
 *         100: {
 *             opacity: 1,
 *             backgroundColor: '00FF00'
 *         }
 *     }
 * });
 * </pre>
 * @see #keyframes
 * @see #event:onKeyframe
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html Original Ext JS documentation of 'Ext.fx.Animator'
 */
public class Animator extends Observable {
  /**
   * @param config @inheritDoc
   */
  public function Animator(config:Animator = null) {
    super();
  }

  /**
   * Current iteration the animation is running.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#property-currentIteration Original Ext JS documentation of 'currentIteration'
   */
  public native function get currentIteration():Number;

  /**
   * @private
   */
  public native function set currentIteration(value:Number):void;

  [ExtConfig]
  /**
   * Time to delay before starting the animation. Defaults to 0.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-delay Original Ext JS documentation of 'delay'
   */
  public native function get delay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set delay(value:Number):void;

  [ExtConfig]
  /**
   * Time in milliseconds for the animation to last. Defaults to 250.
   * @default 250
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-duration Original Ext JS documentation of 'duration'
   */
  public native function get duration():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set duration(value:Number):void;

  [ExtConfig]
  /**
   * Currently only for Component Animation: Only set a component's outer element size bypassing
   * layouts. Set to true to do full layouts for every frame of the animation. Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-dynamic Original Ext JS documentation of 'dynamic'
   */
  public native function get dynamic():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dynamic(value:Boolean):void;

  [ExtConfig]
  /**
   * This describes how the intermediate values used during a transition will be calculated.
   * It allows for a transition to change speed over its duration.
   * <ul>
   * <li>backIn</li>
   * <li>backOut</li>
   * <li>bounceIn</li>
   * <li>bounceOut</li>
   * <li>ease</li>
   * <li>easeIn</li>
   * <li>easeOut</li>
   * <li>easeInOut</li>
   * <li>elasticIn</li>
   * <li>elasticOut</li>
   * <li>cubic-bezier(x1, y1, x2, y2)</li>
   * </ul>
   * <p>Note that cubic-bezier will create a custom easing curve following the CSS3
   * <a href="http://www.w3.org/TR/css3-transitions/#transition-timing-function_tag">transition-timing-function</a> specification. The four values specify points P1 and P2
   * of the curve as (x1, y1, x2, y2). All values must be in the range [0, 1] or the definition
   * is invalid.</p>
   * @default 'ease'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-easing Original Ext JS documentation of 'easing'
   */
  public native function get easing():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set easing(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Animator, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#property-isAnimator Original Ext JS documentation of 'isAnimator'
   */
  public native function get isAnimator():Boolean;

  /**
   * @private
   */
  public native function set isAnimator(value:Boolean):void;

  [ExtConfig]
  /**
   * Number of times to execute the animation. Defaults to 1.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-iterations Original Ext JS documentation of 'iterations'
   */
  public native function get iterations():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set iterations(value:Number):void;

  /**
   * Current keyframe step of the animation.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#property-keyframeStep Original Ext JS documentation of 'keyframeStep'
   */
  public native function get keyframeStep():Number;

  /**
   * @private
   */
  public native function set keyframeStep(value:Number):void;

  [ExtConfig]
  /**
   * Animation keyframes follow the CSS3 Animation configuration pattern. 'from' is always
   * considered '0%' and 'to' is considered '100%'.<b>Every keyframe declaration must have
   * a keyframe rule for 0% and 100%, possibly defined using "from" or "to"</b>.
   * A keyframe declaration without these keyframe selectors is invalid and will not be available
   * for animation. The keyframe declaration for a keyframe rule consists of properties and
   * values. Properties that are unable to be animated are ignored in these rules,
   * with the exception of 'easing' which can be changed at each keyframe. For example:
   * <pre>
   *    keyframes : {
   *        '0%': {
   *            left: 100
   *        },
   *        '40%': {
   *            left: 150
   *        },
   *        '60%': {
   *            left: 75
   *        },
   *        '100%': {
   *            left: 100
   *        }
   *    }
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-keyframes Original Ext JS documentation of 'keyframes'
   */
  public native function get keyframes():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set keyframes(value:Object):void;

  /**
   * Flag to determine if the animation is paused. Only set this to true if you need to
   * keep the Anim instance around to be unpaused later; otherwise call →<code>end()</code>.
   * @default false
   * @see #end()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#property-paused Original Ext JS documentation of 'paused'
   */
  public native function get paused():Boolean;

  /**
   * @private
   */
  public native function set paused(value:Boolean):void;

  /**
   * Flag to determine if the animation has started
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#property-running Original Ext JS documentation of 'running'
   */
  public native function get running():Boolean;

  /**
   * @private
   */
  public native function set running(value:Boolean):void;

  [ExtConfig]
  /**
   * The Ext.fx.target to apply the animation to. If not specified during initialization,
   * this can be passed to the applyAnimator method to apply the same animation to many targets.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#cfg-target Original Ext JS documentation of 'target'
   */
  public native function get target():Target;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:Target):void;

  /**
   * Fire afteranimate event and end the animation. Usually called automatically when the
   * animation reaches its final frame, but can also be called manually to pre-emptively
   * stop and destroy the running animation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Animator.html#method-end Original Ext JS documentation of 'end'
   */
  public native function end():void;
}
}