package ext.fx {
import ext.Base;

[Native]
/**
 * This class contains a series of function definitions used to modify values during an animation.
 * They describe how the intermediate values used during a transition will be calculated. It allows
 * for a transition to change speed over its duration. The following options are available:
 * <ul>
 * <li>linear The default easing type</li>
 * <li>backIn</li>
 * <li>backOut</li>
 * <li>bounceIn</li>
 * <li>bounceOut</li>
 * <li>ease</li>
 * <li>easeIn</li>
 * <li>easeOut</li>
 * <li>easeInOut</li>
 * <li>elasticIn</li>
 * <li>elasticOut</li>
 * <li>cubic-bezier(x1, y1, x2, y2)</li>
 * </ul>
 * <p>Note that cubic-bezier will create a custom easing curve following the CSS3
 * <a href="http://www.w3.org/TR/css3-transitions/#transition-timing-function_tag">transition-timing-function</a> specification. The four values specify points P1 and P2
 * of the curve as (x1, y1, x2, y2). All values must be in the range [0, 1] or the definition
 * is invalid.</p>
 * <p>Type of singleton Easing.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Easing.html Original Ext JS documentation of 'Ext.fx.Easing'
 * @see ext.fx.#Easing ext.fx.Easing
 */
public class SEasing extends Base {
}
}