package ext.fx.events {
import ext.fx.Anim;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.fx.events.Anim_startTimeEvent")]
public class Anim_startTimeEvent extends FlExtEvent {
  /**
   * Fires when the animation is complete.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#event-afteranimate Original Ext JS documentation of 'afteranimate'
   * @see ext.fx.Anim
   * @eventType onAfterAnimate
   */
  public static const AFTER_ANIMATE:String = "onAfterAnimate";
  /**
   * Fires when the animation's last frame has been set.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.Anim.html#event-lastframe Original Ext JS documentation of 'lastframe'
   * @see ext.fx.Anim
   * @eventType onLastFrame
   */
  public static const LAST_FRAME:String = "onLastFrame";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "startTime", "eOpts"];

  public function Anim_startTimeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get source():Anim;

  public native function get startTime():Date;
}
}