package ext.fx.target {

[Native("Ext.fx.target.CompositeElementCSS", require)]
/**
 * This class represents a animation target for a →<code>ext.dom.CompositeElement</code>, where the
 * constituent elements support CSS based animation. It allows each →<code>ext.dom.Element</code> in
 * the group to be animated as a whole. In general this class will not be created directly,
 * the →<code>ext.dom.CompositeElement</code> will be passed to the animation and the appropriate target
 * will be created.
 * @see ext.dom.CompositeElement
 * @see ext.dom.Element
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.target.CompositeElementCSS.html Original Ext JS documentation of 'Ext.fx.target.CompositeElementCSS'
 */
public class CompositeElementCSSTarget extends CompositeElementTarget {
  /**
   * @inheritDoc
   */
  public function CompositeElementCSSTarget(target:* = undefined) {
    super(undefined);
  }
}
}