package ext.fx.target {

[Native("Ext.fx.target.CompositeElement", require)]
/**
 * This class represents a animation target for a →<code>ext.dom.CompositeElement</code>. It allows
 * each →<code>ext.dom.Element</code> in the group to be animated as a whole. In general this class
 * will not be created directly, the →<code>ext.dom.CompositeElement</code> will be passed to the animation
 * and and the appropriate target will be created.
 * @see ext.dom.CompositeElement
 * @see ext.dom.Element
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.target.CompositeElement.html Original Ext JS documentation of 'Ext.fx.target.CompositeElement'
 */
public class CompositeElementTarget extends ElementTarget {
  /**
   * @inheritDoc
   */
  public function CompositeElementTarget(target:* = undefined) {
    super(undefined);
  }

  /**
   * <code>true</code> in this class to identify an object as an instantiated CompositeElement,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.target.CompositeElement.html#property-isComposite Original Ext JS documentation of 'isComposite'
   */
  public native function get isComposite():Boolean;

  /**
   * @private
   */
  public native function set isComposite(value:Boolean):void;
}
}