package ext.fx.target {
import ext.Base;

[Native("Ext.fx.target.Target", require)]
/**
 * This class specifies a generic target for an animation. It provides a wrapper around a
 * series of different types of objects to allow for a generic animation API.
 * A target can be a single object or a Composite object containing other objects that are
 * to be animated. This class and it's subclasses are generally not created directly, the
 * underlying animation will create the appropriate Ext.fx.target.Target object by passing
 * the instance to be animated.
 * <p>The following types of objects can be animated:</p>
 * <ul>
 * <li><i>Components</i> (→<code>ext.fx.target.ComponentTarget</code>)</li>
 * <li><i>Elements</i> (→<code>ext.fx.target.ElementTarget</code>)</li>
 * <li><i>Sprites</i> (→<code>ext.fx.target.SpriteTarget</code>)</li>
 * </ul>
 * @see ext.fx.target.ComponentTarget
 * @see ext.fx.target.ElementTarget
 * @see ext.fx.target.SpriteTarget
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.target.Target.html Original Ext JS documentation of 'Ext.fx.target.Target'
 */
public class Target extends Base {
  /**
   * Creates new Target.
   * @param target The object
   * to be animated
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.fx.target.Target.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Target(target:*) {
    super();
  }
}
}