package ext.grid {
import ext.Base;
import ext.data.Model;
import ext.grid.column.Column;
import ext.view.TableView;

[Native("Ext.grid.CellContext", require)]
/**
 * Instances of this class encapsulate a position in a grid's row/column coordinate system.
 * <p>Cells are addressed using the owning →<code>record</code> and →<code>column</code> for robustness.
 * the column may be moved, the store may be sorted, and the CellContext will still reference
 * the same <i>logical</i> cell. Be aware that due to buffered rendering the <i>physical</i> cell may not
 * exist.</p>
 * <p>The →<code>setPosition()</code> method however allows a numeric row and column to be passed in. These
 * are immediately converted.</p>
 * <p>Be careful not to make <code>CellContext</code> objects <i>too</i> persistent. If the owning record is removed,
 * or the owning column is removed, the reference will be stale.</p>
 * <p>Freshly created context objects, such as those exposed by events from the
 * <i>spreadsheet selection model</i> (→<code>ext.grid.selection.SpreadsheetModelSelection</code>) are safe to use
 * until your application mutates the store, or changes the column set.</p>
 * @see #record
 * @see #column
 * @see #setPosition()
 * @see ext.grid.selection.SpreadsheetModelSelection
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html Original Ext JS documentation of 'Ext.grid.CellContext'
 */
public class CellContext extends Base {
  /**
   * Creates a new CellContext which references a <i>GridView</i> (→<code>ext.view.TableView</code>)
   * @param view The <i>GridView</i> (→<code>ext.view.TableView</code>) for which the cell context
   * is needed.
   * <p>To complete creation of a valid context, use the →<code>setPosition()</code> method.</p>
   * @see ext.view.TableView
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-constructor Original Ext JS documentation of 'constructor'
   * @see #setPosition()
   */
  public function CellContext(view:TableView) {
    super();
  }

  /**
   * The column index in the owning View's leaf column set of the referenced cell.
   * <p><i>Be aware that after the initial call to →<code>setPosition()</code>, this value may become stale
   * due to subsequent column mutation.</i></p>
   * @see #setPosition()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#property-colIdx Original Ext JS documentation of 'colIdx'
   */
  public native function get colIdx():Number;

  /**
   * The grid column which owns the referenced cell.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#property-column Original Ext JS documentation of 'column'
   */
  public native function get column():Column;

  /**
   * <code>true</code> in this class to identify an object as an instantiated CellContext,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#property-isCellContext Original Ext JS documentation of 'isCellContext'
   */
  public native function get isCellContext():Boolean;

  /**
   * The store record which maps to the referenced cell.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#property-record Original Ext JS documentation of 'record'
   */
  public native function get record():Model;

  /**
   * The row number in the store which owns the referenced cell.
   * <p><i>Be aware that after the initial call to →<code>setPosition()</code>, this value may become stale
   * due to subsequent store mutation.</i></p>
   * @see #setPosition()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#property-rowIdx Original Ext JS documentation of 'rowIdx'
   */
  public native function get rowIdx():Number;

  /**
   * Creates a clone of this CellContext.
   * <p>The clone may be retargeted without affecting the reference of this context.</p>
   * @return A copy of this context, referencing the same cell.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():CellContext;

  /**
   * Returns the cell object referenced <i>at the time of calling</i>. Note that grid DOM is transient,
   * and the cell referenced may be removed from the DOM due to paging or buffered rendering
   * or column or record removal.
   * @param returnDom Pass <code>true</code> to return a DOM object instead of an
   * →<code>ext.dom.Element</code>.
   * @return The cell referenced by this context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-getCell Original Ext JS documentation of 'getCell'
   * @see ext.dom.Element
   */
  public native function getCell(returnDom:Boolean = false):*;

  /**
   * Returns the view node object (the encapsulating element of a data row) referenced
   * <i>at the time of calling</i>. Note that grid DOM is transient, and the node referenced
   * may be removed from the DOM due to paging or buffered rendering or column or record removal.
   * @param returnDom Pass <code>true</code> to return a DOM object instead of an
   * →<code>ext.dom.Element</code>.
   * @return The grid item referenced by this context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-getNode Original Ext JS documentation of 'getNode'
   * @see ext.dom.Element
   */
  public native function getNode(returnDom:Boolean):*;

  /**
   * Returns the row object referenced <i>at the time of calling</i>. Note that grid DOM is transient,
   * and the row referenced may be removed from the DOM due to paging or buffered rendering
   * or column or record removal.
   * @param returnDom Pass <code>true</code> to return a DOM object instead of an
   * →<code>ext.dom.Element</code>.
   * @return The grid row referenced by this context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-getRow Original Ext JS documentation of 'getRow'
   * @see ext.dom.Element
   */
  public native function getRow(returnDom:Boolean):*;

  /**
   * Compares this CellContext object to another CellContext to see if they refer to the same
   * cell.
   * @param other The CellContext to compare.
   * @return <code>true</code> if the other cell context references the same cell as this.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-isEqual Original Ext JS documentation of 'isEqual'
   */
  public native function isEqual(other:CellContext):Boolean;

  /**
   * Binds this cell context to a logical cell defined by the →<code>record</code> and →<code>column</code>.
   * @param row The row index or record which owns the required cell.
   * @param col The column index (In the owning View's leaf
   * column set), or the owning <i>column</i> (→<code>ext.grid.column.Column</code>).
   * <p>A one argument form may be used in the form of an array:</p>
   * <pre>
   * [column, row]
   * </pre>
   * <p>Or another CellContext may be passed.</p>
   * @return this CellContext object.
   * @see #record
   * @see #column
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.CellContext.html#method-setPosition Original Ext JS documentation of 'setPosition'
   * @see ext.grid.column.Column
   */
  public native function setPosition(row:*, col:*):CellContext;
}
}