package ext.grid {
import ext.panel.TablePanel;

[Native("Ext.grid.Panel", require)]
/**
 * @see ext.grid.events.GridPanel_store_columns_oldStore_oldColumnsEvent.BEFORE_RECONFIGURE
 * @eventType ext.grid.events.GridPanel_store_columns_oldStore_oldColumnsEvent.BEFORE_RECONFIGURE
 */
[Event(name='onBeforeReconfigure', type='ext.grid.events.GridPanel_store_columns_oldStore_oldColumnsEvent')]
/**
 * @see ext.grid.events.GridPanel_store_columns_oldStore_oldColumnsEvent.RECONFIGURE
 * @eventType ext.grid.events.GridPanel_store_columns_oldStore_oldColumnsEvent.RECONFIGURE
 */
[Event(name='onReconfigure', type='ext.grid.events.GridPanel_store_columns_oldStore_oldColumnsEvent')]
/**
 * Grids are an excellent way of showing large amounts of tabular data on the client side.
 * Essentially a supercharged <code>&lt;table&gt;</code>, GridPanel makes it easy to fetch, sort and filter
 * large amounts of data.
 * <p>Grids are composed of two main pieces - a →<code>ext.data.Store</code> full of data and
 * a set of columns to render.</p>
 * <p><b><i>Basic GridPanel</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     storeId: 'simpsonsStore',
 *     fields:[ 'name', 'email', 'phone'],
 *     data: [
 *         { name: 'Lisa', email: 'lisa&#64;simpsons.com', phone: '555-111-1224' },
 *         { name: 'Bart', email: 'bart&#64;simpsons.com', phone: '555-222-1234' },
 *         { name: 'Homer', email: 'homer&#64;simpsons.com', phone: '555-222-1244' },
 *         { name: 'Marge', email: 'marge&#64;simpsons.com', phone: '555-222-1254' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     store: Ext.data.StoreManager.lookup('simpsonsStore'),
 *     columns: [
 *         { text: 'Name', dataIndex: 'name' },
 *         { text: 'Email', dataIndex: 'email', flex: 1 },
 *         { text: 'Phone', dataIndex: 'phone' }
 *     ],
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>The code above produces a simple grid with three columns. We specified a Store which
 * will load JSON data inline.
 * In most apps we would be placing the grid inside another container and wouldn't need to
 * use the →<code>height</code>, →<code>width</code> and →<code>renderTo</code> configurations but they
 * are included here to make it easy to get up and running.</p>
 * <p>The grid we created above will contain a header bar with a title ('Simpsons'), a row of
 * column headers directly underneath and finally the grid rows under the headers.</p>
 * <p><b>Height config with bufferedRenderer: true</b></p>
 * <p>The →<code>height</code> config must be set when creating a grid using
 * →<code>bufferedRenderer</code>: true <i>and</i> the grid's height is not managed
 * by an owning container layout. In Ext JS 5.x bufferedRendering is true by default.</p>
 * <p><b><i>Configuring columns</i></b></p>
 * <p>By default, each column is sortable and will toggle between ASC and DESC sorting when
 * you click on its header. Each column header is also reorderable by default, and each
 * gains a drop-down menu with options to hide and show columns. It's easy to configure
 * each column - here we use the same example as above and just modify the columns config:</p>
 * <pre>
 * columns: [
 *     {
 *         text: 'Name',
 *         dataIndex: 'name',
 *         sortable: false,
 *         hideable: false,
 *         flex: 1
 *     },
 *     {
 *         text: 'Email',
 *         dataIndex: 'email',
 *         hidden: true
 *     },
 *     {
 *         text: 'Phone',
 *         dataIndex: 'phone',
 *         width: 100
 *     }
 * ]
 * </pre>
 * <p>We turned off sorting and hiding on the 'Name' column so clicking its header now has no
 * effect. We also made the Email column hidden by default (it can be shown again by using
 * the menu on any other column). We also set the Phone column to a fixed with of 100px
 * and flexed the Name column, which means it takes up all remaining width after the other
 * columns have been accounted for. See the <i>column docs</i> (→<code>ext.grid.column.Column</code>) for
 * more details.</p>
 * <p><b><i>Renderers</i></b></p>
 * <p>As well as customizing columns, it's easy to alter the rendering of individual cells
 * using renderers. A renderer is tied to a particular column and is passed the value that
 * would be rendered into each cell in that column. For example, we could define a
 * renderer function for the email column to turn each email address into a mailto link:</p>
 * <pre>
 * columns: [
 *     {
 *         text: 'Email',
 *         dataIndex: 'email',
 *         renderer: function(value) {
 *             return Ext.String.format('&lt;a href="mailto:{0}"&gt;{1}&lt;/a&gt;', value, value);
 *         }
 *     }
 * ]
 * </pre>
 * <p>See the <i>column docs</i> (→<code>ext.grid.column.Column</code>) for more information on renderers.</p>
 * <p><b><i>Selection Models</i></b></p>
 * <p>Sometimes you simply want to render data for viewing, but usually it's
 * necessary to interact with or update that data. Grids use a concept called a Selection
 * Model, which is simply a mechanism for selecting some part of the data in the grid. The
 * two main types of Selection Model are RowSelectionModel, where entire rows are
 * selected, and CellSelectionModel, where individual cells are selected.</p>
 * <p>Grids use a Row Selection Model by default, but this is easy to customize like so:</p>
 * <pre>
 * Ext.create('Ext.grid.Panel', {
 *     selModel: 'cellmodel',
 *     store: ...
 * });
 * </pre>
 * <p>Specifying the <code>cellmodel</code> changes a couple of things. Firstly, clicking on a cell now
 * selects just that cell (using a <i>rowmodel</i> (→<code>ext.selection.RowSelectionModel</code>) will select the
 * entire row), and secondly the keyboard navigation will walk from cell to cell instead
 * of row to row. Cell-based selection models are usually used in conjunction with
 * editing.</p>
 * <p>You may also utilize selModel as a config object for an instance of →<code>ext.selection.SelectionModel</code>.</p>
 * <p>For example:</p>
 * <pre>
 * selModel: {
 *     selType: 'cellmodel',
 *     mode   : 'MULTI'
 * }
 * </pre>
 * <p>This allows you to modify additional selection model configurations such as:</p>
 * <ul>
 * <li>→<code>ext.selection.SelectionModel.mode</code> - Specifies whether user may select multiple
 * rows or single rows</li>
 * <li>→<code>ext.selection.SelectionModel.allowDeselect</code> - Specifies whether user may
 * deselect records (when in SINGLE mode)</li>
 * <li>→<code>ext.selection.SelectionModel.ignoreRightMouseSelection</code> - Specifies
 * whether user may ignore right clicks
 * for selection purposes</li>
 * </ul>
 * <p><b><i>Sorting &amp; Filtering</i></b></p>
 * <p>Every grid is attached to a →<code>ext.data.Store</code>, which provides multi-sort and
 * filtering capabilities. It's
 * easy to set up a grid to be sorted from the start:</p>
 * <pre>
 * var myGrid = Ext.create('Ext.grid.Panel', {
 *     store: {
 *         fields: ['name', 'email', 'phone'],
 *         sorters: ['name', 'phone']
 *     },
 *     columns: [
 *         { text: 'Name',  dataIndex: 'name' },
 *         { text: 'Email', dataIndex: 'email' }
 *     ]
 * });
 * </pre>
 * <p>Sorting at run time is easily accomplished by simply clicking each column header. If
 * you need to perform sorting on more than one field at run time it's easy to do so by
 * adding new sorters to the store:</p>
 * <pre>
 * myGrid.store.sort([
 *     { property: 'name',  direction: 'ASC' },
 *     { property: 'email', direction: 'DESC' }
 * ]);
 * </pre>
 * <p>See →<code>ext.data.Store</code> for examples of filtering.</p>
 * <p><b><i>State saving</i></b></p>
 * <p>When configured →<code>stateful</code>, grids save their column state (order and width)
 * encapsulated within the default Panel state of changed width and height and
 * collapsed/expanded state.</p>
 * <p>On a <code>→stateful</code> grid, not only should the Grid have a →<code>stateId</code>, each
 * <i>column</i> (→<code>columns</code>) of the grid should also be configured with a
 * →<code>ext.grid.column.Column.stateId</code> which identifies that column locally
 * within the grid.</p>
 * <p>Omitting the <code>→stateId</code> config from the columns results in columns with generated
 * internal ID's. The generated ID's are subject to change on each page load
 * making it impossible for the state manager to restore the previous state of the
 * columns.</p>
 * <p><b><i>Plugins and Features</i></b></p>
 * <p>Grid supports addition of extra functionality through features and plugins:</p>
 * <ul>
 * <li>
 * <p>→<code>ext.grid.plugin.CellEditingPlugin</code> - editing grid contents one cell at a time.</p>
 * </li>
 * <li>
 * <p>→<code>ext.grid.plugin.RowEditingPlugin</code> - editing grid contents an entire row at a time.</p>
 * </li>
 * <li>
 * <p>→<code>ext.grid.plugin.GridViewDragDropPlugin</code> - drag-drop reordering of grid rows.</p>
 * </li>
 * <li>
 * <p><i>Paging toolbar</i> (→<code>ext.toolbar.PagingToolbar</code>) - paging through large sets of data.</p>
 * </li>
 * <li>
 * <p><i>Infinite scrolling</i> (→<code>null</code>) - another way to handle
 * large sets of data.</p>
 * </li>
 * <li>
 * <p>→<code>ext.grid.column.RowNumberer</code> - automatically numbered rows.</p>
 * </li>
 * <li>
 * <p>→<code>ext.grid.feature.Grouping</code> - grouping together rows having the same value
 * in a particular field.</p>
 * </li>
 * <li>
 * <p>→<code>ext.grid.feature.Summary</code> - a summary row at the bottom of a grid.</p>
 * </li>
 * <li>
 * <p>→<code>ext.grid.feature.GroupingSummary</code> - a summary row at the bottom
 * of each group.</p>
 * </li>
 * </ul>
 * @see ext.data.Store
 * @see #height
 * @see #width
 * @see #renderTo
 * @see #bufferedRenderer
 * @see ext.grid.column.Column
 * @see ext.selection.RowSelectionModel
 * @see ext.selection.SelectionModel
 * @see ext.selection.SelectionModel#mode
 * @see ext.selection.SelectionModel#allowDeselect
 * @see ext.selection.SelectionModel#ignoreRightMouseSelection
 * @see #stateful
 * @see #stateId
 * @see #columns
 * @see ext.grid.column.Column#stateId
 * @see ext.grid.plugin.CellEditingPlugin
 * @see ext.grid.plugin.RowEditingPlugin
 * @see ext.grid.plugin.GridViewDragDropPlugin
 * @see ext.toolbar.PagingToolbar
 * @see null
 * @see ext.grid.column.RowNumberer
 * @see ext.grid.feature.Grouping
 * @see ext.grid.feature.Summary
 * @see ext.grid.feature.GroupingSummary
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.Panel.html Original Ext JS documentation of 'Ext.grid.Panel'
 */
public class GridPanel extends TablePanel {
  /**
   * @param config @inheritDoc
   */
  public function GridPanel(config:GridPanel = null) {
    super();
  }

  [ExtConfig]
  /**
   * False to remove row line styling
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.Panel.html#cfg-rowLines Original Ext JS documentation of 'rowLines'
   */
  override public native function get rowLines():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set rowLines(value:Boolean):void;

  [ExtConfig]
  /**
   * An xtype of view to use. This is automatically set to 'tableview' by
   * <i>Grid</i> (→<code>ext.grid.GridPanel</code>) and to 'treeview' by <i>Tree</i> (→<code>ext.tree.TreePanel</code>).
   * @default 'tableview'
   * @see ext.grid.GridPanel
   * @see ext.tree.TreePanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.Panel.html#cfg-viewType Original Ext JS documentation of 'viewType'
   */
  override public native function get viewType():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set viewType(value:String):void;
}
}