package ext.grid.column {

[Native("Ext.grid.column.Action", require)]
/**
 * A Grid header type which renders an icon, or a series of icons in a grid cell, and offers
 * a scoped click handler for each icon.
 * <p><b>Example:</b></p>
 * <pre>
 * // Init the singleton.  Any tag-based quick tips will start working.
 * Ext.tip.QuickTipManager.init();
 *
 * Ext.create('Ext.data.Store', {
 *     storeId:'employeeStore',
 *     fields:['firstname', 'lastname', 'seniority', 'dep', 'hired'],
 *     data:[
 *         {firstname:"Michael", lastname:"Scott"},
 *         {firstname:"Dwight", lastname:"Schrute"},
 *         {firstname:"Jim", lastname:"Halpert"},
 *         {firstname:"Kevin", lastname:"Malone"},
 *         {firstname:"Angela", lastname:"Martin"}
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Action Column Demo',
 *     store: Ext.data.StoreManager.lookup('employeeStore'),
 *     columns: [
 *         {text: 'First Name',  dataIndex:'firstname'},
 *         {text: 'Last Name',  dataIndex:'lastname'},
 *         {
 *             xtype:'actioncolumn',
 *             width:50,
 *             items: [{
 *                 iconCls: 'x-fa fa-cog',
 *                 tooltip: 'Edit',
 *                 handler: function(grid, rowIndex, colIndex) {
 *                     var rec = grid.getStore().getAt(rowIndex);
 *                     alert("Edit " + rec.get('firstname'));
 *                 }
 *             },{
 *                 icon: 'extjs-build/examples/restful/images/delete.png',
 *                 tooltip: 'Delete',
 *                 handler: function(grid, rowIndex, colIndex) {
 *                     var rec = grid.getStore().getAt(rowIndex);
 *                     alert("Terminate " + rec.get('firstname'));
 *                 }
 *             }]
 *         }
 *     ],
 *     width: 250,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p>The action column can be at any index in the columns array, and a grid can have any number of
 * action columns.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html Original Ext JS documentation of 'Ext.grid.column.Action'
 */
public class ActionColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function ActionColumn(config:ActionColumn = null) {
    super();
  }

  [ExtConfig]
  /**
   * The alt text to use for the image element.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-altText Original Ext JS documentation of 'altText'
   */
  public native function get altText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set altText(value:String):void;

  [ExtConfig]
  /**
   * If true, the action will not respond to click events, and will be displayed semi-opaque.
   * <p>This Column may also be disabled on a row by row basis by configuring a
   * →<code>isActionDisabled</code> method.</p>
   * @see #isActionDisabled
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-disabled Original Ext JS documentation of 'disabled'
   * @see #setDisabled()
   */
  override public native function get disabled():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set disabled(value:Boolean):void;

  [ExtConfig]
  /**
   * A function which returns the CSS class to apply to the icon image.
   * <p>For information on using the icons provided in the SDK see
   * →<code>iconCls</code>. The function is passed the following params:</p>
   * <ul>
   * <li><code>value:Object</code> —
   * The value of the column's configured field (if any)
   * </li>
   * <li><code>metadata:Object</code> —
   * An object in which you may set the following attributes:
   * <ul>
   * <li><code>css:String</code> (optional) —
   * A CSS class name to add to the cell's TD element
   * </li>
   * <li><code>attr:String</code> (optional) —
   * An HTML attribute definition string to apply to the
   * data container element <i>within</i> the table cell (e.g. 'style="color:red;"')
   * </li>
   * </ul>
   * </li>
   * <li><code>record:ext.data.Model</code> —
   * The Record providing the data
   * </li>
   * <li><code>rowIndex:Number</code> —
   * The row index
   * </li>
   * <li><code>colIndex:Number</code> —
   * The column index
   * </li>
   * <li><code>store:ext.data.Store</code> —
   * The Store which is providing the data Model
   * </li>
   * <li><code>null:String</code> —
   * The CSS class
   * </li>
   * </ul>
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-getClass Original Ext JS documentation of 'getClass'
   */
  public native function get getClass():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set getClass(value:Function):void;

  [ExtConfig]
  /**
   * A function which returns the tooltip string for any row.
   * <p><i>Note</i>: Outside of an Ext.application() use of this config requires
   * →<code>ext.tip.QuickTipManager.init()</code> to be called.</p>
   * <pre>
   * Ext.tip.QuickTipManager.init();
   *
   * Ext.create('Ext.data.Store', {
   *     storeId: 'employeeStore',
   *     fields: ['firstname', 'grade'],
   *     data: [{
   *         firstname: "Michael",
   *         grade: 50
   *     }, {
   *         firstname: "Dwight",
   *         grade: 100
   *     }]
   * });
   *
   * Ext.create('Ext.grid.Panel', {
   *     title: 'Action Column Demo',
   *     store: Ext.data.StoreManager.lookup('employeeStore'),
   *     columns: [{
   *         text: 'First Name',
   *         dataIndex: 'firstname'
   *     }, {
   *         text: 'Last Name',
   *         dataIndex: 'grade'
   *     }, {
   *         xtype: 'actioncolumn',
   *         width: 50,
   *         icon: 'sample/icons/action-icons.png',
   *         getTip: function(value, metadata, record, row, col, store) {
   *             var avg = store.average('grade'),
   *                 grade = record.get('grade');
   *
   *             if (grade &lt; avg) {
   *                 metadata.tdCls = "below-average";
   *             }
   *
   *             return grade &gt; 70 ? 'Pass' : 'Fail';
   *         },
   *         handler: function(grid, rowIndex, colIndex) {
   *             var rec = grid.getStore().getAt(rowIndex);
   *             alert("Edit " + rec.get('firstname'));
   *         }
   *     }],
   *     width: 250,
   *     renderTo: document.body
   * });
   * </pre>
   * <ul>
   * <li><code>value:Object</code> —
   * The value of the column's configured field (if any).
   * </li>
   * <li><code>metadata:Object</code> —
   * An object in which you may set the following attributes:
   * <ul>
   * <li><code>tdCls:String</code> (optional) —
   * A CSS class name to add to the cell's TD element.
   * <pre>
   * metadata.tdCls = "custom-cell-cls";
   * </pre>
   * </li>
   * <li><code>tdAttr:String</code> (optional) —
   * An HTML attribute definition string to apply to
   * the data container element <i>within</i> the table cell.
   * <pre>
   * metadata.tdCls = tdAttr = "&#42;";
   * // &#42; see https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes
   * // be aware that setting cell attributes may override the cell layout
   * // provided by the framework
   * </pre>
   * </li>
   * <li><code>tdStyle:String</code> (optional) —
   * An inline style for the table cell
   * <pre>
   * metadata.tdStyle = "background-color:red;";
   * </pre>
   * </li>
   * </ul>
   * </li>
   * <li><code>record:ext.data.Model</code> —
   * The Record providing the data.
   * </li>
   * <li><code>rowIndex:Number</code> —
   * The row index.
   * </li>
   * <li><code>colIndex:Number</code> —
   * The column index.
   * </li>
   * <li><code>store:ext.data.Store</code> —
   * The Store which is providing the data Model.
   * </li>
   * <li><code>null:String</code> —
   * tip The tip text
   * </li>
   * </ul>
   * @see ext.tip.SQuickTipManager#init() ext.tip.QuickTipManager.init()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-getTip Original Ext JS documentation of 'getTip'
   */
  public native function get getTip():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set getTip(value:Function):void;

  [ExtConfig]
  /**
   * A numeric unicode character code to use as the icon. The default font-family
   * for glyphs can be set globally using
   * →<code>ext.app.Application.glyphFontFamily</code> application
   * config or the →<code>ext.Ext.setGlyphFontFamily()</code> method.
   * It is initially set to <code>'Pictos'</code>.
   * <p>The following shows how to set the glyph using the font icons provided in the
   * SDK (assuming the font-family has been configured globally):</p>
   * <pre>
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'x48'       // the "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 72          // The "home" icon (H character)
   *
   * // assumes the glyphFontFamily is "Pictos"
   * glyph: 'H'         // the "home" icon
   * </pre>
   * <p>Alternatively, this config option accepts a string with the charCode and
   * font-family separated by the <code>&#64;</code> symbol.</p>
   * <pre>
   * // using Font Awesome
   * glyph: 'xf015&#64;FontAwesome'     // the "home" icon
   *
   * // using Pictos
   * glyph: 'H&#64;Pictos'              // the "home" icon
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a></li>
   * </ul>
   * @default null
   * @since 6.2.0
   * @see ext.app.Application#glyphFontFamily
   * @see ext.SExt#setGlyphFontFamily() ext.Ext.setGlyphFontFamily()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-glyph Original Ext JS documentation of 'glyph'
   */
  public native function get glyph():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set glyph(value:*):void;

  [ExtConfig]
  /**
   * A function called when the icon is clicked. The handler function is passed the
   * following params:
   * <ul>
   * <li><code>view:ext.view.TableView</code> —
   * The owning TableView
   * </li>
   * <li><code>rowIndex:Number</code> —
   * The row index clicked on
   * </li>
   * <li><code>colIndex:Number</code> —
   * The column index clicked on
   * </li>
   * <li><code>item:Object</code> —
   * The clicked item (or this Column if multiple
   * →<code>items</code> were not configured)
   * </li>
   * <li><code>e:js.Event</code> —
   * The click event
   * </li>
   * <li><code>record:ext.data.Model</code> —
   * The Record underlying the clicked row
   * </li>
   * <li><code>row:js.HTMLElement</code> —
   * The table row clicked upon
   * </li>
   * </ul>
   * @see #items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-handler Original Ext JS documentation of 'handler'
   */
  public native function get handler():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set handler(value:*):void;

  [ExtConfig]
  /**
   * Path to an image to use as an icon.
   * <p>For instructions on how you can use icon fonts including those distributed in
   * the SDK see →<code>iconCls</code>.</p>
   * @default Ext#BLANK_IMAGE_URL
   * @see #iconCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-icon Original Ext JS documentation of 'icon'
   */
  public native function get icon():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set icon(value:String):void;

  [ExtConfig]
  /**
   * One or more space separated CSS classes to be applied to the icon element.
   * The CSS rule(s) applied should specify a background image to be used as the
   * icon.
   * <p>An example of specifying a custom icon class would be something like:</p>
   * <pre>
   * // specify the property in the config for the class:
   * iconCls: 'my-home-icon'
   *
   * // css rule specifying the background image to be used as the icon image:
   * .my-home-icon {
   *     background-image: url(../images/my-home-icon.gif) !important;
   * }
   * </pre>
   * <p>In addition to specifying your own classes, you can use the font icons
   * provided in the SDK using the following syntax:</p>
   * <pre>
   * // using Font Awesome
   * iconCls: 'x-fa fa-home'
   *
   * // using Pictos
   * iconCls: 'pictos pictos-home'
   * </pre>
   * <p>Depending on the theme you're using, you may need include the font icon
   * packages in your application in order to use the icons included in the
   * SDK. For more information see:</p>
   * <ul>
   * <li><a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/">Font Awesome icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/font_ext.html">Pictos icons</a></li>
   * <li><a href="https://docs.sencha.com/extjs/7.2.0/guides/core_concepts/theming.html">Theming Guide</a>
   * <b>Note:</b> To determine the class dynamically, configure the Column with
   * a <code>→getClass</code> function.</li>
   * </ul>
   * @see #getClass
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-iconCls Original Ext JS documentation of 'iconCls'
   */
  public native function get iconCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set iconCls(value:String):void;

  [ExtConfig("isDisabled")]
  /**
   * This flag indicates that this column will be ignored when grid data is exported.
   * <p>When grid data is exported you may want to export only some columns that are important
   * and not everything. Widget, check and action columns are not relevant when data is
   * exported. You can set this flag on any column that you want to be ignored during export.</p>
   * <p>This is used by <i>clipboard plugin</i> (→<code>ext.grid.plugin.GridClipboardPlugin</code>) and
   * <i>exporter plugin</i> (→<code>null</code>).</p>
   * @default true
   * @see ext.grid.plugin.GridClipboardPlugin
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-ignoreExport Original Ext JS documentation of 'ignoreExport'
   */
  override public native function get ignoreExport():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set ignoreExport(value:Boolean):void;

  [ExtConfig]
  /**
   * A function which determines whether the action
   * item for any row is disabled and returns <code>true</code> or <code>false</code>.
   * <p>The function is passed the following params:</p>
   * <ul>
   * <li><code>view:ext.view.TableView</code> —
   * The owning TableView.
   * </li>
   * <li><code>rowIndex:Number</code> —
   * The row index.
   * </li>
   * <li><code>colIndex:Number</code> —
   * The column index.
   * </li>
   * <li><code>item:Object</code> —
   * The clicked item (or this Column if multiple
   * →<code>items</code> were not configured).
   * </li>
   * <li><code>record:ext.data.Model</code> —
   * The Record underlying the row.
   * </li>
   * <li><code>null:Boolean</code> —
   * <code>true</code> or <code>false</code> indicating whether the action item is disabled
   * </li>
   * </ul>
   * @see #items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-isActionDisabled Original Ext JS documentation of 'isActionDisabled'
   */
  public native function get isActionDisabled():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set isActionDisabled(value:Function):void;

  [Deprecated(replacement="isActionDisabled", since="6.5.0")]
  [ExtConfig]
  /**
   * A function which determines whether the action item for any row
   * is disabled and returns <code>true</code> or <code>false</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-isDisabled Original Ext JS documentation of 'isDisabled'
   */
  public native function get isDisabled_():Function;

  [ExtConfig("isDisabled")]
  /**
   * @private
   */
  public native function set isDisabled_(value:Function):void;

  [ExtConfig]
  /**
   * Default ARIA role for each action item.
   * @default 'button'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-itemAriaRole Original Ext JS documentation of 'itemAriaRole'
   */
  public native function get itemAriaRole():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemAriaRole(value:String):void;

  [ExtConfig]
  /**
   * Default tabIndex attribute value for each action item.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-itemTabIndex Original Ext JS documentation of 'itemTabIndex'
   */
  public native function get itemTabIndex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set itemTabIndex(value:Number):void;

  [ExtConfig]
  /**
   * An array of action items copied from the configured →<code>items</code> configuration.
   * Each will have an <code>enable</code> and <code>disable</code> method added which will enable and disable
   * the associated action, and update the displayed icon accordingly.
   * @see #items
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#property-items Original Ext JS documentation of 'items'
   */
  override public native function get items():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set items(value:Array):void;

  /**
   * This is an internal flag that you use when creating custom components. By default this is set
   * to <code>true</code> which means that every component gets a mask when it's disabled. Components like
   * FieldContainer, FieldSet, Field, Button, Tab override this property to <code>false</code>
   * since they want to implement custom disable logic.
   * On Action Columns the masking applies to the action or actions
   * themselves
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#property-maskOnDisable Original Ext JS documentation of 'maskOnDisable'
   */
  override public native function get maskOnDisable():Boolean;

  /**
   * @private
   */
  override public native function set maskOnDisable(value:Boolean):void;

  [ExtConfig]
  /**
   * The text to render in the column's visibility selection menu for this column. If
   * not specified, menuText will display <i>text's</i> (→<code>text</code>) value.
   * @default '<i>Actions</i>'
   * @see #text
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-menuText Original Ext JS documentation of 'menuText'
   */
  override public native function get menuText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set menuText(value:String):void;

  [ExtConfig]
  /**
   * The scope (<code>this</code> reference) in which the <code>→handler</code>,
   * <code>→getClass</code>, <code>→isActionDisabled</code> and <code>→getTip</code> functions
   * are executed.
   * Defaults to this Column.
   * @see #handler
   * @see #getClass
   * @see #isActionDisabled
   * @see #getTip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-scope Original Ext JS documentation of 'scope'
   */
  override public native function get scope():Object;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * False to disable sorting of this column. Whether local/remote sorting is used is specified in
   * <code>→ext.data.Store.remoteSort</code>.
   * @default false
   * @see ext.data.Store#remoteSort
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-sortable Original Ext JS documentation of 'sortable'
   */
  override public native function get sortable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set sortable(value:Boolean):void;

  [ExtConfig]
  /**
   * Prevent grid selection upon click.
   * Beware that if you allow for the selection to happen then the selection model will steal
   * focus from any possible floating window (like a message box) raised in the handler.
   * This will prevent closing the window when pressing the Escape button since it will no longer
   * contain a focused component.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-stopSelection Original Ext JS documentation of 'stopSelection'
   */
  public native function get stopSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stopSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * A tooltip message to be displayed on hover.
   * <i>Ext.tip.QuickTipManager</i> (→<code>ext.tip.QuickTipManager.init()</code>) must have been initialized.
   * <p>The tooltip may also be determined on a row by row basis by configuring a
   * →<code>getTip</code> method.</p>
   * @see ext.tip.SQuickTipManager#init() ext.tip.QuickTipManager.init()
   * @see #getTip
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   */
  override public native function get tooltip():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tooltip(value:String):void;

  /**
   * Disables this ActionColumn's action at the specified index.
   * @param index
   * @param silent
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#method-disableAction Original Ext JS documentation of 'disableAction'
   */
  public native function disableAction(index:*, silent:Boolean = false):void;

  /**
   * Enables this ActionColumn's action at the specified index.
   * @param index
   * @param silent
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Action.html#method-enableAction Original Ext JS documentation of 'enableAction'
   */
  public native function enableAction(index:*, silent:Boolean = false):void;
}
}