package ext.grid.column {

[Native("Ext.grid.column.Boolean", require)]
/**
 * A Column definition class which renders boolean data fields.
 * See the →<code>ext.grid.column.Column.xtype</code> config option of
 * →<code>ext.grid.column.Column</code> for more details.
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.Store', {
 *    fields: [
 *        {name: 'framework', type: 'string'},
 *        {name: 'rocks', type: 'boolean'}
 *    ],
 *    data: [
 *        { framework: 'Ext JS 5', rocks: true },
 *        { framework: 'Ext GWT', rocks: true },
 *        { framework: 'Other Guys', rocks: false }
 *    ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Boolean Column Demo',
 *     store: store,
 *     columns: [
 *         { text: 'Framework',  dataIndex: 'framework', flex: 1 },
 *         {
 *             xtype: 'booleancolumn',
 *             text: 'Rocks',
 *             trueText: 'Yes',
 *             falseText: 'No',
 *             dataIndex: 'rocks'
 *         }
 *     ],
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.grid.column.Column#xtype
 * @see ext.grid.column.Column
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Boolean.html Original Ext JS documentation of 'Ext.grid.column.Boolean'
 */
public class BooleanColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function BooleanColumn(config:BooleanColumn = null) {
    super();
  }

  [ExtConfig]
  /**
   * The string returned by the renderer when the column value is falsey (but not undefined).
   * @default 'false'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Boolean.html#cfg-falseText Original Ext JS documentation of 'falseText'
   */
  public native function get falseText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set falseText(value:String):void;

  [ExtConfig]
  /**
   * This flag indicates that the renderer produces HTML.
   * <p>If this column is going to be updated rapidly, and the
   * →<code>ext.grid.column.Column.renderer</code> or →<code>updater</code> only produces
   * text, then to avoid the expense of HTML parsing and element production during the
   * update, this property may be configured as <code>false</code>.</p>
   * @default false
   * @see ext.grid.column.Column#renderer
   * @see #updater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Boolean.html#cfg-producesHTML Original Ext JS documentation of 'producesHTML'
   */
  override public native function get producesHTML():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set producesHTML(value:Boolean):void;

  [ExtConfig]
  /**
   * The string returned by the renderer when the column value is not falsey.
   * @default 'true'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Boolean.html#cfg-trueText Original Ext JS documentation of 'trueText'
   */
  public native function get trueText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set trueText(value:String):void;

  [ExtConfig]
  /**
   * The string returned by the renderer when the column value is undefined.
   * @default '\xa0'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Boolean.html#cfg-undefinedText Original Ext JS documentation of 'undefinedText'
   */
  public native function get undefinedText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set undefinedText(value:String):void;
}
}