package ext.grid.column {

[Native("Ext.grid.column.Check", require)]
/**
 * @see ext.grid.column.events.CheckColumn_rowIndex_checked_record_eEvent.BEFORE_CHECK_CHANGE
 * @eventType ext.grid.column.events.CheckColumn_rowIndex_checked_record_eEvent.BEFORE_CHECK_CHANGE
 */
[Event(name='onBeforeCheckChange', type='ext.grid.column.events.CheckColumn_rowIndex_checked_record_eEvent')]
/**
 * @see ext.grid.column.events.CheckColumn_checked_eEvent.BEFORE_HEADER_CHECK_CHANGE
 * @eventType ext.grid.column.events.CheckColumn_checked_eEvent.BEFORE_HEADER_CHECK_CHANGE
 */
[Event(name='onBeforeHeaderCheckChange', type='ext.grid.column.events.CheckColumn_checked_eEvent')]
/**
 * @see ext.grid.column.events.CheckColumn_rowIndex_checked_record_eEvent.CHECK_CHANGE
 * @eventType ext.grid.column.events.CheckColumn_rowIndex_checked_record_eEvent.CHECK_CHANGE
 */
[Event(name='onCheckChange', type='ext.grid.column.events.CheckColumn_rowIndex_checked_record_eEvent')]
/**
 * @see ext.grid.column.events.CheckColumn_checked_eEvent.HEADER_CHECK_CHANGE
 * @eventType ext.grid.column.events.CheckColumn_checked_eEvent.HEADER_CHECK_CHANGE
 */
[Event(name='onHeaderCheckChange', type='ext.grid.column.events.CheckColumn_checked_eEvent')]
/**
 * A Column subclass which renders a checkbox in each column cell which toggles the truthiness
 * of the associated data field on click.
 * <p>Example usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.Store', {
 *     fields: ['name', 'email', 'phone', 'active'],
 *     data: [
 *         { name: 'Lisa', email: 'lisa&#64;simpsons.com', phone: '555-111-1224', active: true },
 *         { name: 'Bart', email: 'bart&#64;simpsons.com', phone: '555-222-1234', active: true },
 *         { name: 'Homer', email: 'homer&#64;simpsons.com', phone: '555-222-1244', active: false },
 *         { name: 'Marge', email: 'marge&#64;simpsons.com', phone: '555-222-1254', active: true }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Simpsons',
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody(),
 *     store: store,
 *     columns: [
 *         { text: 'Name', dataIndex: 'name' },
 *         { text: 'Email', dataIndex: 'email', flex: 1 },
 *         { text: 'Phone', dataIndex: 'phone' },
 *         { xtype: 'checkcolumn', text: 'Active', dataIndex: 'active' }
 *     ]
 * });
 * </pre>
 * <p>The check column can be at any index in the columns array.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html Original Ext JS documentation of 'Ext.grid.column.Check'
 */
public class CheckColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function CheckColumn(config:CheckColumn = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Overridden from base class. Must center to line up with editor.
   * @default 'center'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-align Original Ext JS documentation of 'align'
   * @see #getAlign()
   * @see #setAlign()
   */
  override public native function get align():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set align(value:String):void;

  [ExtConfig]
  /**
   * The tooltip text to show upon hover of an checked cell.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-checkedTooltip Original Ext JS documentation of 'checkedTooltip'
   */
  public native function get checkedTooltip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set checkedTooltip(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configure as <code>true</code> to display a checkbox below the header text.
   * <p>Clicking the checkbox will check/uncheck all records.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-headerCheckbox Original Ext JS documentation of 'headerCheckbox'
   * @see #getHeaderCheckbox()
   * @see #setHeaderCheckbox()
   */
  public native function get headerCheckbox():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set headerCheckbox(value:Boolean):void;

  [ExtConfig]
  /**
   * Use <code>true</code> to display a check when the value is <code>false</code> instead of when the value
   * is <code>true</code>.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-invert Original Ext JS documentation of 'invert'
   */
  public native function get invert():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set invert(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Check column,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#property-isCheckColumn Original Ext JS documentation of 'isCheckColumn'
   */
  public native function get isCheckColumn():Boolean;

  /**
   * @private
   */
  public native function set isCheckColumn(value:Boolean):void;

  [ExtConfig]
  /**
   * Prevent grid selection upon mousedown.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-stopSelection Original Ext JS documentation of 'stopSelection'
   */
  public native function get stopSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stopSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * The tooltip text to show upon hover of a unchecked cell.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-tooltip Original Ext JS documentation of 'tooltip'
   */
  override public native function get tooltip():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tooltip(value:String):void;

  [ExtConfig]
  /**
   * The mouse event which triggers the toggle of a single cell.
   * @default click
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#cfg-triggerEvent Original Ext JS documentation of 'triggerEvent'
   */
  public native function get triggerEvent():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set triggerEvent(value:String):void;

  /**
   * Returns the value of <code>align</code>.
   * @see #align
   */
  override public native function getAlign():String;

  /**
   * Returns the value of <code>headerCheckbox</code>.
   * @see #headerCheckbox
   */
  public native function getHeaderCheckbox():Boolean;

  /**
   * Disables this CheckColumn.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#method-onDisable Original Ext JS documentation of 'onDisable'
   */
  override protected native function onDisable():void;

  /**
   * Enables this CheckColumn.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#method-onEnable Original Ext JS documentation of 'onEnable'
   */
  override protected native function onEnable():void;

  /**
   * Sets the value of <code>align</code>.
   * @param align The new value.
   * @see #align
   */
  override public native function setAlign(align:String):void;

  /**
   * Sets the value of <code>headerCheckbox</code>.
   * @param headerCheckbox The new value.
   * @see #headerCheckbox
   */
  public native function setHeaderCheckbox(headerCheckbox:Boolean):void;
}
}