package ext.grid.column {

[Native("Ext.grid.column.Date", require)]
/**
 * A Column definition class which renders a passed date according to the default locale, or a configured
 * →<code>format</code>.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     storeId:'sampleStore',
 *     fields:[
 *         { name: 'symbol', type: 'string' },
 *         { name: 'date',   type: 'date' },
 *         { name: 'change', type: 'number' },
 *         { name: 'volume', type: 'number' },
 *         { name: 'topday', type: 'date' }
 *     ],
 *     data:[
 *         { symbol: "msft",   date: '2011/04/22', change: 2.43, volume: 61606325, topday: '04/01/2010' },
 *         { symbol: "goog",   date: '2011/04/22', change: 0.81, volume: 3053782,  topday: '04/11/2010' },
 *         { symbol: "apple",  date: '2011/04/22', change: 1.35, volume: 24484858, topday: '04/28/2010' },
 *         { symbol: "sencha", date: '2011/04/22', change: 8.85, volume: 5556351,  topday: '04/22/2010' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Date Column Demo',
 *     store: Ext.data.StoreManager.lookup('sampleStore'),
 *     columns: [
 *         { text: 'Symbol',   dataIndex: 'symbol', flex: 1 },
 *         { text: 'Date',     dataIndex: 'date',   xtype: 'datecolumn',   format:'Y-m-d' },
 *         { text: 'Change',   dataIndex: 'change', xtype: 'numbercolumn', format:'0.00' },
 *         { text: 'Volume',   dataIndex: 'volume', xtype: 'numbercolumn', format:'0,000' },
 *         { text: 'Top Day',  dataIndex: 'topday', xtype: 'datecolumn',   format:'l' }
 *     ],
 *     height: 200,
 *     width: 450,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see #format
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Date.html Original Ext JS documentation of 'Ext.grid.column.Date'
 */
public class DateColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function DateColumn(config:DateColumn = null) {
    super();
  }

  [ExtConfig]
  /**
   * A formatting string as used by →<code>ext.DateUtil.format()</code> to format a Date for this Column.
   * <p>Defaults to the default date from →<code>ext.DateUtil.defaultFormat</code> which itself
   * my be overridden in a locale file.</p>
   * @see ext.SDateUtil#format() ext.DateUtil.format()
   * @see ext.SDateUtil#defaultFormat ext.DateUtil.defaultFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Date.html#cfg-format Original Ext JS documentation of 'format'
   */
  public native function get format():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set format(value:String):void;

  [ExtConfig]
  /**
   * This flag indicates that the renderer produces HTML.
   * <p>If this column is going to be updated rapidly, and the
   * →<code>ext.grid.column.Column.renderer</code> or →<code>updater</code> only produces
   * text, then to avoid the expense of HTML parsing and element production during the
   * update, this property may be configured as <code>false</code>.</p>
   * @default false
   * @see ext.grid.column.Column#renderer
   * @see #updater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Date.html#cfg-producesHTML Original Ext JS documentation of 'producesHTML'
   */
  override public native function get producesHTML():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set producesHTML(value:Boolean):void;
}
}