package ext.grid.column {

[Native("Ext.grid.column.Number", require)]
/**
 * A Column definition class which renders a numeric data field according to a
 * →<code>format</code> string.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *    storeId:'sampleStore',
 *    fields:[
 *        { name: 'symbol', type: 'string' },
 *        { name: 'price',  type: 'number' },
 *        { name: 'change', type: 'number' },
 *        { name: 'volume', type: 'number' }
 *    ],
 *    data:[
 *        { symbol: "msft",   price: 25.76,  change: 2.43, volume: 61606325 },
 *        { symbol: "goog",   price: 525.73, change: 0.81, volume: 3053782  },
 *        { symbol: "apple",  price: 342.41, change: 1.35, volume: 24484858 },
 *        { symbol: "sencha", price: 142.08, change: 8.85, volume: 5556351  }
 *    ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Number Column Demo',
 *     store: Ext.data.StoreManager.lookup('sampleStore'),
 *     columns: [
 *         { text: 'Symbol', dataIndex: 'symbol', flex: 1 },
 *         { text: 'Current Price', dataIndex: 'price',  renderer: Ext.util.Format.usMoney },
 *         { text: 'Change', dataIndex: 'change', xtype: 'numbercolumn', format:'0.00' },
 *         { text: 'Volume', dataIndex: 'volume', xtype: 'numbercolumn', format:'0,000' }
 *     ],
 *     height: 200,
 *     width: 400,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see #format
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Number.html Original Ext JS documentation of 'Ext.grid.column.Number'
 */
public class NumberColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function NumberColumn(config:NumberColumn = null) {
    super();
  }

  [ExtConfig]
  /**
   * A formatting string as used by →<code>ext.util.Format.number()</code> to format a numeric
   * value for this Column.
   * @default '0,000.00'
   * @see ext.util.SFormat#number() ext.util.Format.number()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Number.html#cfg-format Original Ext JS documentation of 'format'
   */
  public native function get format():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set format(value:String):void;

  [ExtConfig]
  /**
   * This flag indicates that the renderer produces HTML.
   * <p>If this column is going to be updated rapidly, and the
   * →<code>ext.grid.column.Column.renderer</code> or →<code>updater</code> only produces
   * text, then to avoid the expense of HTML parsing and element production during the
   * update, this property may be configured as <code>false</code>.</p>
   * @default false
   * @see ext.grid.column.Column#renderer
   * @see #updater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Number.html#cfg-producesHTML Original Ext JS documentation of 'producesHTML'
   */
  override public native function get producesHTML():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set producesHTML(value:Boolean):void;
}
}