package ext.grid.column {

[Native("Ext.grid.column.RowNumberer", require)]
/**
 * A special type of Grid →<code>ext.grid.column.Column</code> that provides automatic
 * row numbering.
 * <p>Usage:</p>
 * <pre>
 * columns: [
 *     {xtype: 'rownumberer'},
 *     {text: "Company", flex: 1, sortable: true, dataIndex: 'company'},
 *     {text: "Price", width: 120, sortable: true, renderer: Ext.util.Format.usMoney, dataIndex: 'price'},
 *     {text: "Change", width: 120, sortable: true, dataIndex: 'change'},
 *     {text: "% Change", width: 120, sortable: true, dataIndex: 'pctChange'},
 *     {text: "Last Updated", width: 120, sortable: true, renderer: Ext.util.Format.dateRenderer('m/d/Y'), dataIndex: 'lastChange'}
 * ]
 * </pre>
 * @see ext.grid.column.Column
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html Original Ext JS documentation of 'Ext.grid.column.RowNumberer'
 */
public class RowNumberer extends Column {
  /**
   * @param config @inheritDoc
   */
  public function RowNumberer(config:RowNumberer = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * Sets the alignment of the header and rendered columns.
   * Possible values are: <code>'start'</code>, <code>'center'</code>, and <code>'end'</code>.
   * <p>Since 6.2.0, <code>'left'</code> and <code>'right'</code> will still work, but retain their meaning
   * even when the application is in RTL mode.</p>
   * <p><code>'start'</code> and <code>'end'</code> always conform to the locale's text direction.</p>
   * @default 'right'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-align Original Ext JS documentation of 'align'
   * @see #getAlign()
   * @see #setAlign()
   */
  override public native function get align():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set align(value:String):void;

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to this component's Element.
   * The value can be a string, a list of strings separated by spaces, or an array of strings.
   * This can be useful for adding customized styles to the component or any of its children
   * using standard CSS rules.
   * @default Ext.baseCSSPrefix + 'row-numberer'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-cls Original Ext JS documentation of 'cls'
   */
  override public native function get cls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set cls(value:String):void;

  [ExtConfig]
  /**
   * The name of the field in the grid's →<code>ext.data.Store</code>'s →<code>ext.data.Model</code>
   * definition from which to draw the column's value. <b>Required.</b>
   * @default ''
   * @see ext.data.Store
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-dataIndex Original Ext JS documentation of 'dataIndex'
   */
  override public native function get dataIndex():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set dataIndex(value:String):void;

  [ExtConfig]
  /**
   * False to disable drag-drop reordering of this column.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-draggable Original Ext JS documentation of 'draggable'
   */
  override public native function get draggable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set draggable(value:*):void;

  [ExtConfig]
  /**
   * False to prevent the user from hiding this column.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-hideable Original Ext JS documentation of 'hideable'
   */
  override public native function get hideable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set hideable(value:Boolean):void;

  [ExtConfig]
  /**
   * This flag indicates that this column will be ignored when grid data is exported.
   * <p>When grid data is exported you may want to export only some columns that are important
   * and not everything. Widget, check and action columns are not relevant when data is
   * exported. You can set this flag on any column that you want to be ignored during export.</p>
   * <p>This is used by <i>clipboard plugin</i> (→<code>ext.grid.plugin.GridClipboardPlugin</code>) and
   * <i>exporter plugin</i> (→<code>null</code>).</p>
   * @default true
   * @see ext.grid.plugin.GridClipboardPlugin
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-ignoreExport Original Ext JS documentation of 'ignoreExport'
   */
  override public native function get ignoreExport():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set ignoreExport(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated RowNumberer,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#property-isRowNumberer Original Ext JS documentation of 'isRowNumberer'
   */
  public native function get isRowNumberer():Boolean;

  /**
   * @private
   */
  public native function set isRowNumberer(value:Boolean):void;

  [ExtConfig]
  /**
   * True to disable the column header menu containing sort/hide options.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-menuDisabled Original Ext JS documentation of 'menuDisabled'
   */
  override public native function get menuDisabled():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set menuDisabled(value:Boolean):void;

  [ExtConfig]
  /**
   * This flag indicates that the renderer produces HTML.
   * <p>If this column is going to be updated rapidly, and the
   * →<code>ext.grid.column.Column.renderer</code> or →<code>updater</code> only produces
   * text, then to avoid the expense of HTML parsing and element production during the
   * update, this property may be configured as <code>false</code>.</p>
   * @default false
   * @see ext.grid.column.Column#renderer
   * @see #updater
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-producesHTML Original Ext JS documentation of 'producesHTML'
   */
  override public native function get producesHTML():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set producesHTML(value:Boolean):void;

  [ExtConfig]
  /**
   * False to prevent the column from being resizable.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-resizable Original Ext JS documentation of 'resizable'
   */
  override public native function get resizable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set resizable(value:*):void;

  [ExtConfig]
  /**
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-sortable Original Ext JS documentation of 'sortable'
   */
  override public native function get sortable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set sortable(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class names to apply to the table cells for this column.
   * @default Ext.baseCSSPrefix + 'grid-cell-row-numberer ' + Ext.baseCSSPrefix + 'grid-cell-special'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-tdCls Original Ext JS documentation of 'tdCls'
   */
  override public native function get tdCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tdCls(value:String):void;

  [ExtConfig]
  /**
   * Any valid text or HTML fragment to display in the header cell for the row number column.
   * @default "&amp;#160;"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-text Original Ext JS documentation of 'text'
   * @see #setText()
   */
  override public native function get text():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set text(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The default width in pixels of the row number column.
   * @default 30
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.RowNumberer.html#cfg-width Original Ext JS documentation of 'width'
   * @see #getWidth()
   * @see #setWidth()
   */
  override public native function get width():*;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set width(value:*):void;

  /**
   * Returns the value of <code>align</code>.
   * @see #align
   */
  override public native function getAlign():String;

  /**
   * Sets the value of <code>align</code>.
   * @param align The new value.
   * @see #align
   */
  override public native function setAlign(align:String):void;
}
}