package ext.grid.column {

[Native("Ext.grid.column.Template", require)]
/**
 * A Column definition class which renders a value by processing a →<code>ext.data.Model</code>'s
 * <i>data</i> (→<code>ext.data.Model.getData()</code>) using a <i>configured</i> (→<code>tpl</code>)
 * →<code>ext.XTemplate</code>.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.data.Store', {
 *     storeId:'employeeStore',
 *     fields:['firstname', 'lastname', 'seniority', 'department'],
 *     groupField: 'department',
 *     data:[
 *         { firstname: "Michael", lastname: "Scott",   seniority: 7, department: "Management" },
 *         { firstname: "Dwight",  lastname: "Schrute", seniority: 2, department: "Sales" },
 *         { firstname: "Jim",     lastname: "Halpert", seniority: 3, department: "Sales" },
 *         { firstname: "Kevin",   lastname: "Malone",  seniority: 4, department: "Accounting" },
 *         { firstname: "Angela",  lastname: "Martin",  seniority: 5, department: "Accounting" }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Column Template Demo',
 *     store: Ext.data.StoreManager.lookup('employeeStore'),
 *     columns: [
 *         { text: 'Full Name',       xtype: 'templatecolumn', tpl: '{firstname} {lastname}', flex:1 },
 *         { text: 'Department (Yrs)', xtype: 'templatecolumn', tpl: '{department} ({seniority})' }
 *     ],
 *     height: 200,
 *     width: 300,
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * @see ext.data.Model
 * @see ext.data.Model#getData()
 * @see #tpl
 * @see ext.XTemplate
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Template.html Original Ext JS documentation of 'Ext.grid.column.Template'
 */
public class TemplateColumn extends Column {
  /**
   * @param config @inheritDoc
   */
  public function TemplateColumn(config:TemplateColumn = null) {
    super();
  }

  [ExtConfig]
  /**
   * @private
   */
  override public native function set scope(value:Object):void;

  [ExtConfig]
  /**
   * An →<code>ext.XTemplate</code>, or an XTemplate <i>definition string</i> to use to process a
   * →<code>ext.data.Model</code>'s data object to produce a cell's rendered value.
   * @see ext.XTemplate
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Template.html#cfg-tpl Original Ext JS documentation of 'tpl'
   */
  override public native function get tpl():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tpl(value:*):void;
}
}