package ext.grid.column.events {
import ext.event.Event;
import ext.grid.column.CheckColumn;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.grid.column.events.CheckColumn_checked_eEvent")]
public class CheckColumn_checked_eEvent extends FlExtEvent {
  /**
   * Fires when the header is clicked and before the mass check/uncheck takes place.
   * The change may be vetoed by returning <code>false</code> from a listener.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#event-beforeheadercheckchange Original Ext JS documentation of 'beforeheadercheckchange'
   * @see ext.grid.column.CheckColumn
   * @eventType onBeforeHeaderCheckChange
   */
  public static const BEFORE_HEADER_CHECK_CHANGE:String = "onBeforeHeaderCheckChange";
  /**
   * Fires after the header is clicked and a mass check/uncheck operation has been completed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.column.Check.html#event-headercheckchange Original Ext JS documentation of 'headercheckchange'
   * @see ext.grid.column.CheckColumn
   * @eventType onHeaderCheckChange
   */
  public static const HEADER_CHECK_CHANGE:String = "onHeaderCheckChange";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "checked", "e", "eOpts"];

  public function CheckColumn_checked_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * <code>true</code> if all boxes are to be checked.
   */
  public native function get checked():Boolean;

  /**
   * The underlying event which caused the check change.
   */
  public native function get e():Event;

  /**
   * CheckColumn.
   */
  public native function get source():CheckColumn;
}
}