package ext.grid.feature {

[Native("Ext.grid.feature.AbstractSummary", require)]
/**
 * A small abstract class that contains the shared behaviour for any summary
 * calculations to be used in the grid.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html Original Ext JS documentation of 'Ext.grid.feature.AbstractSummary'
 */
public class AbstractSummary extends Feature implements IAbstractSummary {
  /**
   * @param config @inheritDoc
   */
  public function AbstractSummary(config:AbstractSummary = null) {
    super();
  }

  [ExtConfig]
  /**
   * True to show the summary row.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html#cfg-showSummaryRow Original Ext JS documentation of 'showSummaryRow'
   */
  public native function get showSummaryRow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showSummaryRow(value:Boolean):void;

  /**
   * Toggle whether or not to show the summary row.
   * @param visible True to show the summary row
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html#method-toggleSummaryRow Original Ext JS documentation of 'toggleSummaryRow'
   */
  public native function toggleSummaryRow(visible:Boolean):void;
}
}