package ext.grid.feature {
import ext.data.Model;

[Native("Ext.grid.feature.Grouping", require)]
/**
 * @see ext.grid.feature.events.Grouping_view_node_group_eEvent.GROUP_CLICK
 * @eventType ext.grid.feature.events.Grouping_view_node_group_eEvent.GROUP_CLICK
 */
[Event(name='onGroupClick', type='ext.grid.feature.events.Grouping_view_node_group_eEvent')]
/**
 * @see ext.grid.feature.events.Grouping_view_node_groupEvent.GROUP_COLLAPSE
 * @eventType ext.grid.feature.events.Grouping_view_node_groupEvent.GROUP_COLLAPSE
 */
[Event(name='onGroupCollapse', type='ext.grid.feature.events.Grouping_view_node_groupEvent')]
/**
 * @see ext.grid.feature.events.Grouping_view_node_group_eEvent.GROUP_CONTEXT_MENU
 * @eventType ext.grid.feature.events.Grouping_view_node_group_eEvent.GROUP_CONTEXT_MENU
 */
[Event(name='onGroupContextMenu', type='ext.grid.feature.events.Grouping_view_node_group_eEvent')]
/**
 * @see ext.grid.feature.events.Grouping_view_node_group_eEvent.GROUP_DBLCLICK
 * @eventType ext.grid.feature.events.Grouping_view_node_group_eEvent.GROUP_DBLCLICK
 */
[Event(name='onGroupDblclick', type='ext.grid.feature.events.Grouping_view_node_group_eEvent')]
/**
 * @see ext.grid.feature.events.Grouping_view_node_groupEvent.GROUP_EXPAND
 * @eventType ext.grid.feature.events.Grouping_view_node_groupEvent.GROUP_EXPAND
 */
[Event(name='onGroupExpand', type='ext.grid.feature.events.Grouping_view_node_groupEvent')]
/**
 * This feature allows to display the grid rows aggregated into groups as specified by the
 * →<code>ext.data.Store.grouper</code> underneath. The groups can also be expanded and collapsed.
 * <p><b><i>Extra Events</i></b></p>
 * <p>This feature adds several extra events that will be fired on the grid to interact
 * with the groups:</p>
 * <ul>
 * <li>→<code>event:onGroupClick</code></li>
 * <li>→<code>event:onGroupDblclick</code></li>
 * <li>→<code>event:onGroupContextMenu</code></li>
 * <li>→<code>event:onGroupExpand</code></li>
 * <li>→<code>event:onGroupCollapse</code></li>
 * </ul>
 * <p><b><i>Menu Augmentation</i></b></p>
 * <p>This feature adds extra options to the grid column menu to provide the user with functionality
 * to modify the grouping. This can be disabled by setting the →<code>enableGroupingMenu</code> option.
 * The option to disallow grouping from being turned off by the user is →<code>enableNoGroups</code>.</p>
 * <p><b><i>Controlling Group Text</i></b></p>
 * <p>The →<code>groupHeaderTpl</code> is used to control the rendered title for each group. It can modified
 * to customized the default display.</p>
 * <p><b><i>Groupers</i></b></p>
 * <p>By default, this feature expects that the data field that is mapped to by the
 * →<code>ext.data.AbstractStore.groupField</code> config is a simple data type such as a
 * String or a Boolean. However, if you intend to group by a data field that is a
 * complex data type such as an Object or Array, it is necessary to define one or more
 * <i>groupers</i> (→<code>ext.util.Grouper</code>) on the feature that it can then use to lookup
 * internal group information when grouping by different fields.</p>
 * <pre>
 * var feature = Ext.create('Ext.grid.feature.Grouping', {
 *     startCollapsed: true,
 *     groupers: [{
 *         property: 'asset',
 *         groupFn: function(val) {
 *             return val.data.name;
 *         }
 *     }]
 * });
 * </pre>
 * <p><b><i>Example Usage</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * var store = Ext.create('Ext.data.Store', {
 *     fields: ['name', 'seniority', 'department'],
 *     groupField: 'department',
 *     data: [
 *         { name: 'Michael Scott', seniority: 7, department: 'Management' },
 *         { name: 'Dwight Schrute', seniority: 2, department: 'Sales' },
 *         { name: 'Jim Halpert', seniority: 3, department: 'Sales' },
 *         { name: 'Kevin Malone', seniority: 4, department: 'Accounting' },
 *         { name: 'Angela Martin', seniority: 5, department: 'Accounting' }
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     title: 'Employees',
 *     store: store,
 *     columns: [
 *         { text: 'Name', dataIndex: 'name', flex: 1 },
 *         { text: 'Seniority', dataIndex: 'seniority', flex: 1 }
 *     ],
 *     features: [{ftype:'grouping'}],
 *     renderTo: Ext.getBody()
 * });
 * </pre>
 * <p><b>Note:</b> To use grouping with a grid that has
 * <i>locked columns</i> (→<code>ext.grid.column.Column.locked</code>), you need to supply the grouping feature
 * as a config object - so the grid can create two instances of the grouping feature.</p>
 * <p><b><i>Grouping Summary</i></b></p>
 * <p>An aggregate summary row may be added at the bottom of each group by setting
 * →<code>showSummaryRow</code> to <code>true</code>. There are two
 * aspects to the summary:</p>
 * <p><b><i>Calculation</i></b></p>
 * <p>The summary value needs to be calculated for each column in the grid. This is
 * controlled by the →<code>ext.grid.column.Column.summaryType</code> option
 * specified on the column. There are several built in summary types which can be
 * specified as a string on the column configuration. These call underlying methods on
 * the store:</p>
 * <ul>
 * <li>→<code>ext.data.Store.count()</code></li>
 * <li>→<code>ext.data.Store.sum()</code></li>
 * <li>→<code>ext.data.Store.min()</code></li>
 * <li>→<code>ext.data.Store.max()</code></li>
 * <li>→<code>ext.data.Store.average()</code></li>
 * </ul>
 * <p>Alternatively, the summaryType can be a function definition. If this is the case,
 * the function is called with two parameters:</p>
 * <ul>
 * <li>records {Array} - an array of records</li>
 * <li>values {Array} - an array of field values to calculate the summary value</li>
 * </ul>
 * <p><b><i>Rendering</i></b></p>
 * <p>Similar to a column, the summary also supports a
 * →<code>null.summaryRenderer</code> function. This
 * summaryRenderer is called before displaying a value. The function is optional. If
 * not specified, the default calculated value is shown. The summaryRenderer is called
 * with:</p>
 * <ul>
 * <li>value {Object} - The calculated value.</li>
 * <li>summaryData {Object} - Contains all raw summary values for the row.</li>
 * <li>field {String} - The name of the field we are calculating</li>
 * <li>metaData {Object} - A collection of metadata about the current cell; can be used or
 * modified by the renderer.</li>
 * </ul>
 * <p><b><i>Example Usage</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('TestResult', {
 *     extend: 'Ext.data.Model',
 *     fields: ['student', 'subject', {
 *         name: 'mark',
 *         type: 'int'
 *     }]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     width: 200,
 *     height: 240,
 *     renderTo: document.body,
 *     features: [{
 *         ftype: 'grouping',
 *         groupHeaderTpl: 'Subject: {name}',
 *         showSummaryRow: true
 *     }],
 *     store: {
 *         model: 'TestResult',
 *         groupField: 'subject',
 *         data: [{
 *             student: 'Student 1',
 *             subject: 'Math',
 *             mark: 84
 *         },{
 *             student: 'Student 1',
 *             subject: 'Science',
 *             mark: 72
 *         },{
 *             student: 'Student 2',
 *             subject: 'Math',
 *             mark: 96
 *         },{
 *             student: 'Student 2',
 *             subject: 'Science',
 *             mark: 68
 *         }]
 *     },
 *     columns: [{
 *         dataIndex: 'student',
 *         text: 'Name',
 *         summaryType: 'count',
 *         summaryRenderer: function(value){
 *             return Ext.String.format('{0} student{1}', value, value !== 1 ? 's' : '');
 *         }
 *     }, {
 *         dataIndex: 'mark',
 *         text: 'Mark',
 *         summaryType: 'average'
 *     }]
 * });
 * </pre>
 * @see ext.data.Store#grouper
 * @see #event:onGroupClick
 * @see #event:onGroupDblclick
 * @see #event:onGroupContextMenu
 * @see #event:onGroupExpand
 * @see #event:onGroupCollapse
 * @see #enableGroupingMenu
 * @see #enableNoGroups
 * @see #groupHeaderTpl
 * @see ext.data.AbstractStore#groupField
 * @see ext.util.Grouper
 * @see ext.grid.column.Column#locked
 * @see #showSummaryRow
 * @see ext.grid.column.Column#summaryType
 * @see ext.data.Store#count()
 * @see ext.data.Store#sum()
 * @see ext.data.Store#min()
 * @see ext.data.Store#max()
 * @see ext.data.Store#average()
 * @see null#summaryRenderer
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html Original Ext JS documentation of 'Ext.grid.feature.Grouping'
 */
public class Grouping extends Feature implements IAbstractSummary {
  /**
   * @param config @inheritDoc
   */
  public function Grouping(config:Grouping = null) {
    super();
  }

  [ExtConfig]
  /**
   * The tooltip for the group expander tool when the group is expanded.
   * @default 'Click to collapse. CTRL/click collapses all others'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-collapseTip Original Ext JS documentation of 'collapseTip'
   */
  public native function get collapseTip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapseTip(value:String):void;

  [ExtConfig]
  /**
   * Set to <code>false</code> to disable collapsing groups from the UI.
   * <p>This is set to <code>false</code> when the associated <i>store</i> (→<code>ext.data.Store</code>) is
   * a →<code>ext.data.BufferedStore</code>.</p>
   * @default true
   * @see ext.data.Store
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-collapsible Original Ext JS documentation of 'collapsible'
   */
  public native function get collapsible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set collapsible(value:Boolean):void;

  [ExtConfig]
  /**
   * Number of pixels to indent per grouping level
   * @default 17
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-depthToIndent Original Ext JS documentation of 'depthToIndent'
   */
  public native function get depthToIndent():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set depthToIndent(value:Number):void;

  [ExtConfig]
  /**
   * True to enable the grouping control in the header menu.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-enableGroupingMenu Original Ext JS documentation of 'enableGroupingMenu'
   */
  public native function get enableGroupingMenu():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableGroupingMenu(value:Boolean):void;

  [ExtConfig]
  /**
   * True to allow the user to turn off grouping.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-enableNoGroups Original Ext JS documentation of 'enableNoGroups'
   */
  public native function get enableNoGroups():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableNoGroups(value:Boolean):void;

  [ExtConfig]
  /**
   * The tooltip for the group expander tool when the group is collapsed.
   * @default 'Click to expand. CTRL key collapses all others'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-expandTip Original Ext JS documentation of 'expandTip'
   */
  public native function get expandTip():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandTip(value:String):void;

  [ExtConfig]
  /**
   * Text displayed in the grid header menu for grouping by header.
   * @default "Group by this field"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-groupByText Original Ext JS documentation of 'groupByText'
   */
  public native function get groupByText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set groupByText(value:String):void;

  [ExtConfig]
  /**
   * A string Template snippet, an array of strings (optionally followed by an object
   * containing Template methods) to be used to construct a Template, or a Template instance.
   * <ul>
   * <li>
   * <p>Example 1 (Template snippet):</p>
   * <pre>
   * groupHeaderTpl: 'Group: {name}'
   * </pre>
   * </li>
   * <li>
   * <p>Example 2 (Array):</p>
   * <pre>
   * groupHeaderTpl: [
   *     'Group: ',
   *     '&lt;div&gt;{name:this.formatName}&lt;/div&gt;',
   *     {
   *         formatName: function(name) {
   *             return Ext.String.trim(name);
   *         }
   *     }
   * ]
   * </pre>
   * </li>
   * <li>
   * <p>Example 3 (Template Instance):</p>
   * <pre>
   * groupHeaderTpl: Ext.create('Ext.XTemplate',
   *     'Group: ',
   *     '&lt;div&gt;{name:this.formatName}&lt;/div&gt;',
   *     {
   *         formatName: function(name) {
   *             return Ext.String.trim(name);
   *         }
   *     }
   * )
   * </pre>
   * </li>
   * </ul>
   * @default '{columnName}: {name}'
   * <ul>
   * <li><code>groupField:String</code> (optional) —
   * The field name being grouped by.
   * </li>
   * <li><code>columnName:String</code> (optional) —
   * The column header associated with the field
   * being grouped by <i>if there is a column for the field</i>, falls back to the groupField name.
   * </li>
   * <li><code>groupValue</code> (optional) —
   * The value of the
   * →<code>ext.data.Store.groupField</code> for the group header being rendered.
   * </li>
   * <li><code>renderedGroupValue:String</code> (optional) —
   * The rendered value of the
   * →<code>ext.data.Store.groupField</code> for the group header being rendered,
   * as produced by the column renderer.
   * </li>
   * <li><code>name:String</code> (optional) —
   * An alias for renderedGroupValue
   * </li>
   * <li><code>rows:Array</code> (optional) —
   * Deprecated - use children instead.
   * An array containing the child records for the group being rendered.
   * <i>Not available if the store is a BufferedStore (→<code>ext.data.BufferedStore</code>)</i>
   * </li>
   * <li><code>children:Array</code> (optional) —
   * An array containing the child records
   * for the group being rendered. <i>Not available if the store is a
   * BufferedStore (→<code>ext.data.BufferedStore</code>)</i>
   * </li>
   * </ul>
   * @see ext.data.Store#groupField
   * @see ext.data.BufferedStore
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-groupHeaderTpl Original Ext JS documentation of 'groupHeaderTpl'
   */
  public native function get groupHeaderTpl():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set groupHeaderTpl(value:*):void;

  [ExtConfig]
  /**
   * These are grouper objects defined for the feature. If the group names are derived
   * from complex data types, it is necessary to convert them as a store would.
   * <p>However, since only one grouper can be defined on the store at a time and
   * this feature clears the current grouper when a new one is added, it is
   * necessary to define a cache of groupers that the feature can lookup as needed.</p>
   * <p>Expected grouper object properties are <code>property</code> and <code>groupFn</code>.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-groupers Original Ext JS documentation of 'groupers'
   */
  public native function get groupers():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set groupers(value:Array):void;

  [ExtConfig]
  /**
   * True to hide the header that is currently grouped.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-hideGroupedHeader Original Ext JS documentation of 'hideGroupedHeader'
   */
  public native function get hideGroupedHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideGroupedHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * The name of the property which contains the Array of summary objects.
   * It allows to use server-side calculated summaries.
   * <p>Alternatively, the →<code>ext.data.reader.DataReader.summaryRootProperty</code> can
   * be used to specify the container for summary data from the server. This allows
   * the →<code>ext.data.Model</code> to determine this when configuring its proxy.</p>
   * @see ext.data.reader.DataReader#summaryRootProperty
   * @see ext.data.Model
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-remoteRoot Original Ext JS documentation of 'remoteRoot'
   */
  public native function get remoteRoot():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set remoteRoot(value:String):void;

  [ExtConfig]
  /**
   * Text displayed in the grid header for enabling/disabling grouping.
   * @default "Show in groups"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-showGroupsText Original Ext JS documentation of 'showGroupsText'
   */
  public native function get showGroupsText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showGroupsText(value:String):void;

  /**
   * True to show the summary row.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html#cfg-showSummaryRow Original Ext JS documentation of 'showSummaryRow'
   */
  public native function get showSummaryRow():Boolean;

  /**
   * @private
   */
  public native function set showSummaryRow(value:Boolean):void;

  [ExtConfig]
  /**
   * True to start all groups collapsed.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#cfg-startCollapsed Original Ext JS documentation of 'startCollapsed'
   */
  public native function get startCollapsed():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startCollapsed(value:Boolean):void;

  /**
   * Collapse a group
   * @param groupName The group name.
   * @param options Pass when the group should be scrolled into view.
   * This contains flags for postProcessing the group's header row after
   * collapsing. See →<code>ext.panel.TablePanel.ensureVisible()</code> for details.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#method-collapse Original Ext JS documentation of 'collapse'
   * @see ext.panel.TablePanel#ensureVisible()
   */
  public native function collapse(groupName:String, options:Object = null):void;

  /**
   * Collapse all groups
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#method-collapseAll Original Ext JS documentation of 'collapseAll'
   */
  public native function collapseAll():void;

  /**
   * Expand a group
   * @param groupName The group name.
   * @param options Pass when the group should be scrolled into view.
   * This contains flags for postProcessing the group's first row after
   * expansion. See →<code>ext.panel.TablePanel.ensureVisible()</code> for details. <i>note:</i>
   * a boolean may be passed to indicate whether to focus the target group after expand.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#method-expand Original Ext JS documentation of 'expand'
   * @see ext.panel.TablePanel#ensureVisible()
   */
  public native function expand(groupName:String, options:Object = null):void;

  /**
   * Expand all groups
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#method-expandAll Original Ext JS documentation of 'expandAll'
   */
  public native function expandAll():void;

  /**
   * Returns the group data object for the group to which the passed record belongs
   * <b>if the Store is grouped</b>.
   * @param record The record for which to return group information.
   * @return A single group data block as returned from
   * →<code>ext.data.Store.getGroups()</code>. Returns <code>undefined</code> if the Store
   * is not grouped.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#method-getRecordGroup Original Ext JS documentation of 'getRecordGroup'
   * @see ext.data.Store#getGroups()
   */
  public native function getRecordGroup(record:Model):Object;

  /**
   * Returns <code>true</code> if the named group is expanded.
   * @param groupName The group name. This is the value of
   * the →<code>ext.data.Store.groupField</code>.
   * @return <code>true</code> if the group defined by that value is expanded.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Grouping.html#method-isExpanded Original Ext JS documentation of 'isExpanded'
   * @see ext.data.Store#groupField
   */
  public native function isExpanded(groupName:String):Boolean;

  /**
   * @inheritDoc
   */
  public native function toggleSummaryRow(visible:Boolean):void;
}
}