package ext.grid.feature {

[Mixin("ext.grid.feature.AbstractSummary")]
/**
 * A small abstract class that contains the shared behaviour for any summary
 * calculations to be used in the grid.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html Original Ext JS documentation of 'Ext.grid.feature.AbstractSummary'
 * @see ext.grid.feature.AbstractSummary
 */
public interface IAbstractSummary extends IFeature {
  [ExtConfig] /**
   * True to show the summary row.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html#cfg-showSummaryRow Original Ext JS documentation of 'showSummaryRow'
   */
  function get showSummaryRow():Boolean;

  [ExtConfig] function set showSummaryRow(value:Boolean):void;

  /**
   * Toggle whether or not to show the summary row.
   * @param visible True to show the summary row
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.AbstractSummary.html#method-toggleSummaryRow Original Ext JS documentation of 'toggleSummaryRow'
   */
  function toggleSummaryRow(visible:Boolean):void;
}
}