package ext.grid.feature {
import ext.data.Model;

[Native("Ext.grid.feature.RowBody", require)]
/**
 * The rowbody feature enhances the grid's markup to have an additional
 * tr -&gt; td -&gt; div which spans the entire width of the original row.
 * <p>This is useful to to associate additional information with a particular
 * record in an Ext.grid.Grid.</p>
 * <p>Rowbodies are initially hidden unless you override →<code>getAdditionalData()</code>.</p>
 * <p>The events fired by RowBody are relayed to the owning
 * <i>grid view</i> (→<code>ext.view.TableView</code>) (and subsequently the owning grid).</p>
 * <p><b>Example</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('Animal', {
 *     extend: 'Ext.data.Model',
 *     fields: ['name', 'latin', 'desc', 'lifespan']
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     width: 400,
 *     height: 300,
 *     renderTo: Ext.getBody(),
 *     store: {
 *         model: 'Animal',
 *         data: [{
 *             name: 'Tiger',
 *             latin: 'Panthera tigris',
 *             desc: 'The largest cat species, weighing up to 306 kg (670 lb).',
 *             lifespan: '20 - 26 years (in captivity)'
 *         }, {
 *             name: 'Roman snail',
 *             latin: 'Helix pomatia',
 *             desc: 'A species of large, edible, air-breathing land snail.',
 *             lifespan: '20 - 35 years'
 *         }, {
 *             name: 'Yellow-winged darter',
 *             latin: 'Sympetrum flaveolum',
 *             desc: 'A dragonfly found in Europe and mid and Northern China.',
 *             lifespan: '4 - 6 weeks'
 *         }, {
 *             name: 'Superb Fairy-wren',
 *             latin: 'Malurus cyaneus',
 *             desc: 'Common and familiar across south-eastern Australia.',
 *             lifespan: '5 - 6 years'
 *         }]
 *     },
 *     columns: [{
 *         dataIndex: 'name',
 *         text: 'Common name',
 *         width: 125
 *     }, {
 *         dataIndex: 'latin',
 *         text: 'Scientific name',
 *         flex: 1
 *     }],
 *     features: [{
 *         ftype: 'rowbody',
 *         getAdditionalData: function(data, idx, record, orig) {
 *             // Usually you would style the my-body-class in a CSS file
 *             return {
 *                 rowBody: '&lt;div style="padding: 1em"&gt;' + record.get("desc") + '&lt;/div&gt;',
 *                 rowBodyCls: "my-body-class"
 *             };
 *         }
 *     }],
 *     listeners: {
 *         rowbodyclick: function(view, rowEl, e, eOpts) {
 *             var itemEl = Ext.get(rowEl).up(view.itemSelector),
 *                 rec = view.getRecord(itemEl);
 *
 *             Ext.Msg.alert(rec.get('name') + ' life span', rec.get('lifespan'));
 *         }
 *     }
 * });
 * </pre>
 * <p><b>Cell Editing and Cell Selection Model</b></p>
 * <p>Note that if <i>cell editing</i> (→<code>ext.grid.plugin.CellEditingPlugin</code>) or the
 * <i>cell selection model</i> (→<code>ext.selection.CellSelectionModel</code>) are going to be used, then the
 * →<code>ext.grid.feature.RowBody</code> feature, or
 * →<code>ext.grid.plugin.RowExpanderPlugin</code> plugin MUST be used for intra-cell navigation
 * to be correct.</p>
 * <p><b>Note:</b> The <i>rowexpander</i> (→<code>ext.grid.plugin.RowExpanderPlugin</code>) plugin and the rowbody
 * feature are exclusive and cannot both be set on the same grid / tree.</p>
 * @see #getAdditionalData()
 * @see ext.view.TableView
 * @see ext.grid.plugin.CellEditingPlugin
 * @see ext.selection.CellSelectionModel
 * @see ext.grid.feature.RowBody
 * @see ext.grid.plugin.RowExpanderPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.RowBody.html Original Ext JS documentation of 'Ext.grid.feature.RowBody'
 */
public class RowBody extends Feature {
  /**
   * @param config @inheritDoc
   */
  public function RowBody(config:RowBody = null) {
    super();
  }

  [ExtConfig]
  /**
   * Configure as <code>true</code> to put the row expander body <i>before</i> the data row.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.RowBody.html#cfg-bodyBefore Original Ext JS documentation of 'bodyBefore'
   */
  public native function get bodyBefore():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set bodyBefore(value:Boolean):void;

  /**
   * Provides additional data to the prepareData call within the grid view.
   * The rowbody feature adds 3 additional variables into the grid view's template.
   * These are <code>rowBody</code>, <code>rowBodyCls</code>, and <code>rowBodyColspan</code>.
   * <ul>
   * <li><b>rowBody:</b> <i>{String}</i> The HTML to display in the row body element. Defaults
   * to <i>undefined</i>.</li>
   * <li><b>rowBodyCls:</b> <i>{String}</i> An optional CSS class (or multiple classes
   * separated by spaces) to apply to the row body element. Defaults to
   * →<code>rowBodyCls</code>.</li>
   * <li><b>rowBodyColspan:</b> <i>{Number}</i> The number of columns that the row body element
   * should span. Defaults to the number of visible columns.</li>
   * </ul>
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param data The data for this particular record.
   * @param idx The row index for this record.
   * @param record The record instance
   * @param orig The original result from the prepareData call to massage.
   * @return An object containing additional variables for use in the grid
   * view's template
   * @see #rowBodyCls
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.RowBody.html#method-getAdditionalData Original Ext JS documentation of 'getAdditionalData'
   */
  protected native function getAdditionalData(data:Object, idx:Number, record:Model, orig:Object):Object;
}
}