package ext.grid.feature {

[Native("Ext.grid.feature.Summary", require)]
/**
 * This feature is used to place a summary row at the bottom of the grid. If using a grouping,
 * see →<code>ext.grid.feature.GroupingSummary</code>. There are 2 aspects to calculating the summaries,
 * calculation and rendering.
 * <p><b><i>Calculation</i></b></p>
 * <p>The summary value needs to be calculated for each column in the grid. This is controlled
 * by the summaryType option specified on the column. There are several built in summary types,
 * which can be specified as a string on the column configuration. These call underlying methods
 * on the store:</p>
 * <ul>
 * <li>→<code>ext.data.Store.count()</code></li>
 * <li>→<code>ext.data.Store.sum()</code></li>
 * <li>→<code>ext.data.Store.min()</code></li>
 * <li>→<code>ext.data.Store.max()</code></li>
 * <li>→<code>ext.data.Store.average()</code></li>
 * </ul>
 * <p>Alternatively, the summaryType can be a function definition. If this is the case,
 * the function is called with an array of records to calculate the summary value.</p>
 * <p><b><i>Rendering</i></b></p>
 * <p>Similar to a column, the summary also supports a summaryRenderer function. This
 * summaryRenderer is called before displaying a value. The function is optional, if
 * not specified the default calculated value is shown. The summaryRenderer is called with:</p>
 * <ul>
 * <li>value {Object} - The calculated value.</li>
 * <li>summaryData {Object} - Contains all raw summary values for the row.</li>
 * <li>field {String} - The name of the field we are calculating</li>
 * <li>metaData {Object} - A collection of metadata about the current cell; can be used or modified
 * by the renderer.</li>
 * </ul>
 * <p><b><i>Example Usage</i></b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.define('TestResult', {
 *     extend: 'Ext.data.Model',
 *     fields: ['student', {
 *         name: 'mark',
 *         type: 'int'
 *     }]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     width: 400,
 *     height: 200,
 *     title: 'Summary Test',
 *     style: 'padding: 20px',
 *     renderTo: document.body,
 *     features: [{
 *         ftype: 'summary'
 *     }],
 *     store: {
 *         model: 'TestResult',
 *         data: [{
 *             student: 'Student 1',
 *             mark: 84
 *         },{
 *             student: 'Student 2',
 *             mark: 72
 *         },{
 *             student: 'Student 3',
 *             mark: 96
 *         },{
 *             student: 'Student 4',
 *             mark: 68
 *         }]
 *     },
 *     columns: [{
 *         dataIndex: 'student',
 *         text: 'Name',
 *         summaryType: 'count',
 *         summaryRenderer: function(value, summaryData, dataIndex) {
 *             return Ext.String.format('{0} student{1}', value, value !== 1 ? 's' : '');
 *         }
 *     }, {
 *         dataIndex: 'mark',
 *         text: 'Mark',
 *         summaryType: 'average'
 *     }]
 * });
 * </pre>
 * @see ext.grid.feature.GroupingSummary
 * @see ext.data.Store#count()
 * @see ext.data.Store#sum()
 * @see ext.data.Store#min()
 * @see ext.data.Store#max()
 * @see ext.data.Store#average()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Summary.html Original Ext JS documentation of 'Ext.grid.feature.Summary'
 */
public class Summary extends AbstractSummary {
  /**
   * @param config @inheritDoc
   */
  public function Summary(config:Summary = null) {
    super();
  }

  [ExtConfig]
  /**
   * Configure <code>'top'</code> or <code>'bottom'</code> top create a fixed summary row either above or below
   * the scrollable table.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.feature.Summary.html#cfg-dock Original Ext JS documentation of 'dock'
   */
  public native function get dock():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dock(value:String):void;
}
}