package ext.grid.filters {
import ext.data.AbstractStore;
import ext.data.Store;
import ext.plugin.AbstractPlugin;
import ext.util.IStoreHolder;

[Native("Ext.grid.filters.Filters", require)]
/**
 * This class is a grid <i>plugin</i> (→<code>ext.plugin.AbstractPlugin</code>) that adds a simple and flexible
 * presentation for <i>store filters</i> (→<code>ext.data.AbstractStore.filters</code>).
 * <p>Filters can be modified by the end-user using the grid's column header menu. Through
 * this menu users can configure, enable, and disable filters for each column.</p>
 * <p><b>Example Usage</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *     fields: ['id','show'],
 *     data: [
 *         {id: 0, show: 'Battlestar Galactica'},
 *         {id: 1, show: 'Doctor Who'},
 *         {id: 2, show: 'Farscape'},
 *         {id: 3, show: 'Firefly'},
 *         {id: 4, show: 'Star Trek'},
 *         {id: 5, show: 'Star Wars: Christmas Special'}
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     renderTo: Ext.getBody(),
 *     title: 'Sci-Fi Television',
 *     height: 250,
 *     width: 250,
 *     store: shows,
 *     plugins: {
 *         gridfilters: true
 *     },
 *     columns: [{
 *         dataIndex: 'id',
 *         text: 'ID',
 *         width: 50
 *     },{
 *         dataIndex: 'show',
 *         text: 'Show',
 *         flex: 1,
 *         filter: {
 *             // required configs
 *             type: 'string',
 *             // optional configs
 *             value: 'star',  // setting a value makes the filter active.
 *             itemDefaults: {
 *                 // any Ext.form.field.Text configs accepted
 *             }
 *         }
 *     }]
 * });
 * </pre>
 * <p><b>Features</b></p>
 * <p><b><i>Filtering implementations</i></b></p>
 * <p>Currently provided filter types are:</p>
 * <ul>
 * <li><code>boolean (→ext.grid.filters.filter.BooleanFilter)</code></li>
 * <li><code>date (→ext.grid.filters.filter.DateFilter)</code></li>
 * <li><code>list (→ext.grid.filters.filter.ListFilter)</code></li>
 * <li><code>number (→ext.grid.filters.filter.NumberFilter)</code></li>
 * <li><code>string (→ext.grid.filters.filter.StringFilter)</code></li>
 * </ul>
 * <p><b>Note:</b> You can find inline examples for each filter on its specific filter page.</p>
 * <p><b><i>Graphical Indicators</i></b></p>
 * <p>Columns that are filtered have <i>CSS class</i> (→<code>filterCls</code>) applied to their column
 * headers. This style can be managed using that CSS class or by setting these Sass
 * variables in your theme or application:</p>
 * <pre>
 *  $grid-filters-column-filtered-font-style: italic !default;
 *
 *  $grid-filters-column-filtered-font-weight: bold !default;
 * </pre>
 * <p><b><i>Stateful</i></b></p>
 * <p>Filter information will be persisted across page loads by specifying a <code>→stateId</code>
 * in the Grid configuration. In actuality this state is saved by the <code>store</code>, but this
 * plugin ensures that saved filters are properly identified and reclaimed on subsequent
 * visits to the page.</p>
 * <p><b><i>Grid Changes</i></b></p>
 * <ul>
 * <li>A <code>filters</code> property is added to the Grid using this plugin.</li>
 * </ul>
 * <p><b>Upgrading From Ext.ux.grid.FilterFeature</b></p>
 * <p>The biggest change for developers converting from the user extension is most likely the
 * conversion to standard <i>store filters</i> (→<code>ext.data.AbstractStore.filters</code>). In the
 * process, the "like" and "in" operators are now supported by <code>→ext.util.Filter</code>.
 * These filters and all other filters added to the store will be sent in the standard
 * way (using the "filters" parameter by default).</p>
 * <p>Since this plugin now uses actual store filters, the <code>onBeforeLoad</code> listener and all
 * helper methods that were used to clean and build the params have been removed. The store
 * will send the filters managed by this plugin along in its normal request.</p>
 * @see ext.plugin.AbstractPlugin
 * @see ext.data.AbstractStore#filters
 * @see ext.grid.filters.filter.BooleanFilter
 * @see ext.grid.filters.filter.DateFilter
 * @see ext.grid.filters.filter.ListFilter
 * @see ext.grid.filters.filter.NumberFilter
 * @see ext.grid.filters.filter.StringFilter
 * @see #filterCls
 * @see #stateId
 * @see ext.util.Filter
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html Original Ext JS documentation of 'Ext.grid.filters.Filters'
 */
public class Filters extends AbstractPlugin implements IStoreHolder {
  /**
   * @param config @inheritDoc
   */
  public function Filters(config:Filters = null) {
    super();
  }

  /**
   * @inheritDoc
   */
  public native function get autoDestroyBoundStore():Boolean;

  /**
   * @inheritDoc
   */
  public native function set autoDestroyBoundStore(value:Boolean):void;

  /**
   * The CSS applied to column headers with active filters.
   * @default "x-grid-filters-filtered-column"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#property-filterCls Original Ext JS documentation of 'filterCls'
   */
  public native function get filterCls():String;

  /**
   * @private
   */
  public native function set filterCls(value:String):void;

  [ExtConfig]
  /**
   * The text for the filters menu.
   * @default 'Filters'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#cfg-menuFilterText Original Ext JS documentation of 'menuFilterText'
   */
  public native function get menuFilterText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set menuFilterText(value:String):void;

  [ExtConfig]
  /**
   * Defaults to true, including a filter submenu in the default header menu.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#cfg-showMenu Original Ext JS documentation of 'showMenu'
   */
  public native function get showMenu():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set showMenu(value:Boolean):void;

  [ExtConfig]
  /**
   * Name of the value to be used to store state information.
   * @default undefined
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#cfg-stateId Original Ext JS documentation of 'stateId'
   */
  public native function get stateId():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stateId(value:String):void;

  /**
   * Adds a filter to the collection and creates a store filter if has a <code>value</code> property.
   * @param filters A filter
   * configuration or a filter object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#method-addFilter Original Ext JS documentation of 'addFilter'
   */
  public native function addFilter(filters:*):void;

  /**
   * Adds filters to the collection.
   * @param filters An Array of filter configuration objects.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#method-addFilters Original Ext JS documentation of 'addFilters'
   */
  public native function addFilters(filters:Array):void;

  /**
   * @inheritDoc
   */
  public native function bindStore(store:Store = undefined, initial:Boolean = undefined, propertyName:* = undefined):void;

  /**
   * Binds listeners for this component to the store. By default it will add
   * anything bound by the getStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to bind to
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-bindStoreListeners Original Ext JS documentation of 'bindStoreListeners'
   */
  protected native function bindStoreListeners(store:AbstractStore):void;

  /**
   * Turns all filters off. This does not clear the configuration information.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#method-clearFilters Original Ext JS documentation of 'clearFilters'
   */
  public native function clearFilters():void;

  /**
   * @inheritDoc
   */
  public native function getStore():AbstractStore;

  /**
   * Gets the listeners to bind to a new store.
   * @param store The Store which is being bound to for which a listeners object
   * should be returned.
   * @return The listeners to be bound to the store in object literal form. The scope
   * may be omitted, it is assumed to be the current instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-getStoreListeners Original Ext JS documentation of 'getStoreListeners'
   */
  protected native function getStoreListeners(store:Store):Object;

  /**
   * Checks the plugin's grid for statefulness.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.Filters.html#method-isStateful Original Ext JS documentation of 'isStateful'
   */
  public native function isStateful():Boolean;

  /**
   * Template method, it is called when a new store is bound
   * to the current instance.
   * @param store The store being bound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onBindStore Original Ext JS documentation of 'onBindStore'
   */
  protected native function onBindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * Template method, it is called when an existing store is unbound
   * from the current instance.
   * @param store The store being unbound
   * @param initial True if this store is being bound as initialization of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-onUnbindStore Original Ext JS documentation of 'onUnbindStore'
   */
  protected native function onUnbindStore(store:AbstractStore, initial:Boolean):void;

  /**
   * @inheritDoc
   */
  public native function setStore(store:Object):void;

  /**
   * Unbinds listeners from this component to the store. By default it will remove
   * anything bound by the bindStoreListeners method, however it can be overridden
   * in a subclass to provide any more complicated handling.
   * @param store The store to unbind from
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.util.StoreHolder.html#method-unbindStoreListeners Original Ext JS documentation of 'unbindStoreListeners'
   */
  protected native function unbindStoreListeners(store:AbstractStore):void;
}
}