package ext.grid.filters.filter {
import ext.Base;
import ext.menu.Menu;
import ext.mixin.IFactoryable;

[Native("Ext.grid.filters.filter.Base", require)]
/**
 * Abstract base class for filter implementations.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html Original Ext JS documentation of 'Ext.grid.filters.filter.Base'
 */
public class BaseFilter extends Base implements IFactoryable {
  /**
   * Initializes the filter given its configuration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function BaseFilter(config:BaseFilter = null) {
    super();
  }

  [ExtConfig]
  /**
   * True if this filter is active. Use setActive() to alter after configuration. If
   * you set a value, the filter will be actived automatically.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#property-active Original Ext JS documentation of 'active'
   * @see #setActive()
   */
  public native function get active():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set active(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.data.Store</code> dataIndex of the field this filter represents.
   * The dataIndex does not actually have to exist in the store.
   * @see ext.data.Store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#cfg-dataIndex Original Ext JS documentation of 'dataIndex'
   */
  public native function get dataIndex():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dataIndex(value:String):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The default configuration options for any menu items created by this filter.
   * <p>Example usage:</p>
   * <pre>
   *  itemDefaults: {
   *      width: 150
   *  },
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#cfg-itemDefaults Original Ext JS documentation of 'itemDefaults'
   * @see #getItemDefaults()
   * @see #setItemDefaults()
   */
  public native function get itemDefaults():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set itemDefaults(value:Object):void;

  /**
   * The filter configuration menu that will be installed into the filter submenu
   * of a column menu.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#property-menu Original Ext JS documentation of 'menu'
   */
  public native function get menu():Menu;

  /**
   * @private
   */
  public native function set menu(value:Menu):void;

  [ExtConfig]
  [Bindable]
  /**
   * A function to post-process any serialization. Accepts a filter state object
   * containing <code>property</code>, <code>value</code> and <code>operator</code> properties, and may either
   * mutate it, or return a completely new representation.
   * @since 6.2.0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#cfg-serializer Original Ext JS documentation of 'serializer'
   * @see #getSerializer()
   * @see #setSerializer()
   */
  public native function get serializer():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set serializer(value:Function):void;

  /**
   * The filter type. Used by the filters.Feature class when adding filters and applying state.
   * @default 'string'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#property-type Original Ext JS documentation of 'type'
   */
  public native function get type():String;

  /**
   * @private
   */
  public native function set type(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Number of milliseconds to wait after user interaction to fire an update. Only supported
   * by filters: 'list', 'numeric', and 'string'.
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#cfg-updateBuffer Original Ext JS documentation of 'updateBuffer'
   * @see #getUpdateBuffer()
   * @see #setUpdateBuffer()
   */
  public native function get updateBuffer():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set updateBuffer(value:Number):void;

  /**
   * Destroys this filter by purging any event listeners, and removing any menus.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Returns the value of <code>itemDefaults</code>.
   * @see #itemDefaults
   */
  public native function getItemDefaults():Object;

  /**
   * Returns the value of <code>serializer</code>.
   * @see #serializer
   */
  public native function getSerializer():Function;

  /**
   * Returns the value of <code>updateBuffer</code>.
   * @see #updateBuffer
   */
  public native function getUpdateBuffer():Number;

  /**
   * Sets the status of the filter and fires the appropriate events.
   * @param active The new filter state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Base.html#method-setActive Original Ext JS documentation of 'setActive'
   */
  public native function setActive(active:Boolean):void;

  /**
   * Sets the value of <code>itemDefaults</code>.
   * @param itemDefaults The new value.
   * @see #itemDefaults
   */
  public native function setItemDefaults(itemDefaults:Object):void;

  /**
   * Sets the value of <code>serializer</code>.
   * @param serializer The new value.
   * @see #serializer
   */
  public native function setSerializer(serializer:Function):void;

  /**
   * Sets the value of <code>updateBuffer</code>.
   * @param updateBuffer The new value.
   * @see #updateBuffer
   */
  public native function setUpdateBuffer(updateBuffer:Number):void;
}
}