package ext.grid.filters.filter {

[Native("Ext.grid.filters.filter.Boolean", require)]
/**
 * The boolean grid filter allows you to create a filter selection that limits results
 * to values matching true or false. The filter can be set programmatically or via
 * user input with a configurable <i>radio field</i> (→<code>ext.form.field.Radio</code>) in the filter section
 * of the column header.
 * <p>Boolean filters use unique radio group IDs, so you may utilize more than one.</p>
 * <p>Example Boolean Filter Usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *     fields: ['id','show', 'visible'],
 *     data: [
 *         {id: 0, show: 'Battlestar Galactica', visible: true},
 *         {id: 1, show: 'Doctor Who', visible: true},
 *         {id: 2, show: 'Farscape', visible: false},
 *         {id: 3, show: 'Firefly', visible: true},
 *         {id: 4, show: 'Star Trek', visible: true},
 *         {id: 5, show: 'Star Wars: Christmas Special', visible: false}
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     renderTo: Ext.getBody(),
 *     title: 'Sci-Fi Television',
 *     height: 250,
 *     width: 375,
 *     store: shows,
 *     plugins: {
 *         gridfilters: true
 *     },
 *     columns: [{
 *         dataIndex: 'id',
 *         text: 'ID',
 *         width: 50
 *     },{
 *         dataIndex: 'show',
 *         text: 'Show',
 *         flex: 1
 *     },{
 *         dataIndex: 'visible',
 *         text: 'Visibility',
 *         width: 125,
 *         filter: {
 *             type: 'boolean',
 *             value: true,
 *             yesText: 'True',
 *             noText: 'False'
 *         }
 *     }]
 * });
 * </pre>
 * @see ext.form.field.Radio
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Boolean.html Original Ext JS documentation of 'Ext.grid.filters.filter.Boolean'
 */
public class BooleanFilter extends SingleFilter {
  /**
   * @param config @inheritDoc
   */
  public function BooleanFilter(config:BooleanFilter = null) {
    super();
  }

  [ExtConfig]
  /**
   * Set this to null if you do not want either option to be checked by default.
   * Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Boolean.html#cfg-defaultValue Original Ext JS documentation of 'defaultValue'
   */
  public native function get defaultValue():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultValue(value:Boolean):void;

  [ExtConfig]
  /**
   * The text to display for <code>false</code>.
   * @default 'No'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Boolean.html#cfg-noText Original Ext JS documentation of 'noText'
   */
  public native function get noText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set noText(value:String):void;

  [ExtConfig]
  /**
   * The text to display for <code>true</code>.
   * @default 'Yes'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Boolean.html#cfg-yesText Original Ext JS documentation of 'yesText'
   */
  public native function get yesText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set yesText(value:String):void;
}
}