package ext.grid.filters.filter {
import ext.picker.DatePicker;

[Native("Ext.grid.filters.filter.Date", require)]
/**
 * The date grid filter allows you to create a filter selection that limits results
 * to values matching specific date constraints. The filter can be set programmatically or via
 * user input with a configurable <i>DatePicker menu</i> (→<code>ext.picker.DatePicker</code>) in the filter section
 * of the column header.
 * <p>Example Date Filter Usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *     fields: ['id','show', {
 *           name: 'airDate',
 *           type: 'date',
 *           dateFormat: 'Y-m-d'
 *     }],
 *     data: [
 *         {id: 0, show: 'Battlestar Galactica', airDate: '1978-09-17'},
 *         {id: 1, show: 'Doctor Who', airDate: '1963-11-23'},
 *         {id: 2, show: 'Farscape', airDate: '1999-03-19'},
 *         {id: 3, show: 'Firefly', airDate: '2002-12-20'},
 *         {id: 4, show: 'Star Trek', airDate: '1966-09-08'},
 *         {id: 5, show: 'Star Wars: Christmas Special', airDate: '1978-11-17'}
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     renderTo: Ext.getBody(),
 *     title: 'Sci-Fi Television',
 *     height: 250,
 *     width: 375,
 *     store: shows,
 *     plugins: {
 *         gridfilters: true
 *     },
 *     columns: [{
 *         dataIndex: 'id',
 *         text: 'ID',
 *         width: 50
 *     },{
 *         dataIndex: 'show',
 *         text: 'Show',
 *         flex: 1
 *     },{
 *         xtype: 'datecolumn',
 *         dataIndex: 'airDate',
 *         text: 'Original Air Date',
 *         width: 125,
 *         filter: {
 *             type: 'date',
 *
 *             // optional picker config
 *             pickerDefaults: {
 *                 // any DatePicker configs
 *             }
 *         }
 *     }]
 * });
 * </pre>
 * @see ext.picker.DatePicker
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html Original Ext JS documentation of 'Ext.grid.filters.filter.Date'
 */
public class DateFilter extends TriFilter {
  /**
   * @param config @inheritDoc
   */
  public function DateFilter(config:DateFilter = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * The date format to return when using getValue.
   * Defaults to →<code>ext.DateUtil.defaultFormat</code>.
   * @default undefined
   * @see ext.SDateUtil#defaultFormat ext.DateUtil.defaultFormat
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#cfg-dateFormat Original Ext JS documentation of 'dateFormat'
   * @see #getDateFormat()
   * @see #setDateFormat()
   */
  public native function get dateFormat():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dateFormat(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configures field items individually. These properties override those defined
   * by <code>→itemDefaults</code>.
   * <p>Example usage:
   * fields: {
   * gt: { // override fieldCfg options
   * width: 200
   * }
   * },</p>
   * @default {
   *     lt: {
   *         text: 'Before'
   *     },
   *     gt: {
   *         text: 'After'
   *     },
   *     eq: {
   *         text: 'On'
   *     }
   * }
   * @see #itemDefaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#cfg-fields Original Ext JS documentation of 'fields'
   * @see #getFields()
   * @see #setFields()
   */
  public native function get fields():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fields(value:Object):void;

  [ExtConfig]
  /**
   * Allowable date as passed to the Ext.DatePicker
   * Defaults to undefined.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#cfg-maxDate Original Ext JS documentation of 'maxDate'
   */
  public native function get maxDate():Date;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maxDate(value:Date):void;

  [ExtConfig]
  /**
   * Allowable date as passed to the Ext.DatePicker
   * Defaults to undefined.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#cfg-minDate Original Ext JS documentation of 'minDate'
   */
  public native function get minDate():Date;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minDate(value:Date):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configuration options for the date picker associated with each field.
   * @default {
   *     xtype: 'datepicker',
   *     border: 0
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#cfg-pickerDefaults Original Ext JS documentation of 'pickerDefaults'
   * @see #getPickerDefaults()
   * @see #setPickerDefaults()
   */
  public native function get pickerDefaults():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set pickerDefaults(value:Object):void;

  /**
   * Returns the value of <code>dateFormat</code>.
   * @see #dateFormat
   */
  public native function getDateFormat():String;

  /**
   * Returns the value of <code>fields</code>.
   * @see #fields
   */
  public native function getFields():Object;

  /**
   * Gets the menu picker associated with the passed field
   * @param item The field identifier ('lt', 'gt', 'eq')
   * @return The menu picker
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#method-getPicker Original Ext JS documentation of 'getPicker'
   */
  public native function getPicker(item:String):Object;

  /**
   * Returns the value of <code>pickerDefaults</code>.
   * @see #pickerDefaults
   */
  public native function getPickerDefaults():Object;

  /**
   * Handler for when the DatePicker for a field fires the 'select' event
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Date.html#method-onMenuSelect Original Ext JS documentation of 'onMenuSelect'
   */
  public native function onMenuSelect(picker:DatePicker, date:Object):void;

  /**
   * Sets the value of <code>dateFormat</code>.
   * @param dateFormat The new value.
   * @see #dateFormat
   */
  public native function setDateFormat(dateFormat:String):void;

  /**
   * Sets the value of <code>fields</code>.
   * @param fields The new value.
   * @see #fields
   */
  public native function setFields(fields:Object):void;

  /**
   * Sets the value of <code>pickerDefaults</code>.
   * @param pickerDefaults The new value.
   * @see #pickerDefaults
   */
  public native function setPickerDefaults(pickerDefaults:Object):void;
}
}