package ext.grid.filters.filter {
import ext.data.Store;

[Native("Ext.grid.filters.filter.List", require)]
/**
 * The list grid filter allows you to create a filter selection that limits results
 * to values matching an element in a list. The filter can be set programmatically or via
 * user input with a configurable <i>check box field</i> (→<code>ext.form.field.Checkbox</code>) in the filter
 * section of the column header.
 * <p>List filters are able to be preloaded/backed by an Ext.data.Store to load
 * their options the first time they are shown. They are also able to create their own
 * list of values from all unique values of the specified →<code>dataIndex</code> field in
 * the store at first time of filter invocation.</p>
 * <p>Example List Filter Usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *     fields: ['id','show','rating'],
 *     data: [
 *         {id: 0, show: 'Battlestar Galactica', rating: 2},
 *         {id: 1, show: 'Doctor Who', rating: 4},
 *         {id: 2, show: 'Farscape', rating: 3},
 *         {id: 3, show: 'Firefly', rating: 4},
 *         {id: 4, show: 'Star Trek', rating: 1},
 *         {id: 5, show: 'Star Wars: Christmas Special', rating: 5}
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     renderTo: Ext.getBody(),
 *     title: 'Sci-Fi Television',
 *     height: 250,
 *     width: 350,
 *     store: shows,
 *     plugins: {
 *         gridfilters: true
 *     },
 *     columns: [{
 *         dataIndex: 'id',
 *         text: 'ID',
 *         width: 50
 *     },{
 *         dataIndex: 'show',
 *         text: 'Show',
 *         flex: 1
 *     },{
 *         dataIndex: 'rating',
 *         text: 'Rating',
 *         width: 75,
 *         filter: {
 *             type: 'list',
 *             value: 5
 *         }
 *     }]
 * });
 * </pre>
 * <p><b><i>Options</i></b></p>
 * <p>There are three means to determine the list of options to present to the user:</p>
 * <ul>
 * <li>The <code>→options</code> config.</li>
 * <li>The <code>→store</code> config. In this mode, the <code>→idField</code>
 * and <code>→labelField</code> configs are used to extract the presentation and
 * filtering values from the <code>→store</code> and apply to the menu items and grid store
 * filter, respectively.</li>
 * <li>If none of the above is specified, the associated grid's store is used. In this
 * case, the <code>→dataIndex</code> is used to determine the filter values and
 * the <code>→labelIndex</code> is used to populate the menu items. These fields
 * are extracted from the records in the associated grid's store. Both of these
 * configs default to the column's <code>→dataIndex</code> property.</li>
 * </ul>
 * <p>In all of these modes, a store is created that is synchronized with the menu items.
 * The records in this store have <code>→idField</code> and <code>→labelField</code>
 * fields that get populated from which ever source was provided.</p>
 * <pre>
 * var filters = Ext.create('Ext.grid.Panel', {
 *     ...
 *     columns: [{
 *         text: 'Size',
 *         dataIndex: 'size',
 *
 *         filter: {
 *             type: 'list',
 *             // options will be used as data to implicitly creates an ArrayStore
 *             options: ['extra small', 'small', 'medium', 'large', 'extra large']
 *         }
 *     }],
 *     ...
 * });
 * </pre>
 * @see ext.form.field.Checkbox
 * @see #dataIndex
 * @see #options
 * @see #store
 * @see #idField
 * @see #labelField
 * @see #labelIndex
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html Original Ext JS documentation of 'Ext.grid.filters.filter.List'
 */
public class ListFilter extends SingleFilter {
  /**
   * @param config @inheritDoc
   */
  public function ListFilter(config:ListFilter = null) {
    super();
  }

  [ExtConfig]
  /**
   * The field name for the <code>id</code> of records in this list's <code>→store</code>. These values are
   * used to populate the filter for the grid's store.
   * @default "id"
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-idField Original Ext JS documentation of 'idField'
   */
  public native function get idField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set idField(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * See the <i>documentation</i> (→<code>ext.grid.filters.filter.BaseFilter.itemDefaults</code>) for
   * the base class for details.
   * <p>In the case of this class, however, note that the <code>checked</code> config should <b>not</b> be
   * specified.</p>
   * @default {
   *     checked: false,
   *     hideOnClick: false
   * }
   * @see ext.grid.filters.filter.BaseFilter#itemDefaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-itemDefaults Original Ext JS documentation of 'itemDefaults'
   * @see #getItemDefaults()
   * @see #setItemDefaults()
   */
  override public native function get itemDefaults():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set itemDefaults(value:Object):void;

  [ExtConfig]
  /**
   * The field name for the menu item text in the records in this list's <code>→store</code>.
   * @default "text"
   * @see #store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-labelField Original Ext JS documentation of 'labelField'
   */
  public native function get labelField():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelField(value:String):void;

  [ExtConfig]
  /**
   * The field in the records of the grid's store from which the menu item text should be
   * retrieved. This field is only used when no <code>→options</code> and no <code>→store</code>
   * is provided and the distinct value of the grid's store need to be generated dynamically.
   * <p>If not provided, this field defaults to the column's <code>→dataIndex</code> property.</p>
   * @since 5.1.0
   * @see #options
   * @see #store
   * @see #dataIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-labelIndex Original Ext JS documentation of 'labelIndex'
   */
  public native function get labelIndex():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set labelIndex(value:String):void;

  [ExtConfig]
  /**
   * Defaults to true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-loadOnShow Original Ext JS documentation of 'loadOnShow'
   */
  public native function get loadOnShow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadOnShow(value:Boolean):void;

  [ExtConfig]
  /**
   * The text that is displayed while the configured store is loading.
   * @default 'Loading...'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-loadingText Original Ext JS documentation of 'loadingText'
   */
  public native function get loadingText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set loadingText(value:String):void;

  [ExtConfig]
  /**
   * The data to be used to implicitly create a data store to back this list. This is used only
   * when the data source is <b>local</b>. If the data for the list is remote, use the →<code>store</code>
   * config instead.
   * <p>If neither store nor →<code>options</code> is specified, then the choices list is automatically
   * populated from all unique values of the specified →<code>dataIndex</code> field in the store
   * at first time of filter invocation.</p>
   * <p>Each item within the provided array may be in one of the following formats:</p>
   * <ul>
   * <li>
   * <p><b>Array</b> :</p>
   * <pre>
   * options: [
   *     [11, 'extra small'],
   *     [18, 'small'],
   *     [22, 'medium'],
   *     [35, 'large'],
   *     [44, 'extra large']
   * ]
   * </pre>
   * </li>
   * <li>
   * <p><b>Object</b> :</p>
   * <pre>
   * labelField: 'name', // override default of 'text'
   * options: [
   *     {id: 11, name:'extra small'},
   *     {id: 18, name:'small'},
   *     {id: 22, name:'medium'},
   *     {id: 35, name:'large'},
   *     {id: 44, name:'extra large'}
   * ]
   * </pre>
   * </li>
   * <li>
   * <p><b>String</b> :</p>
   * <pre>
   * options: ['extra small', 'small', 'medium', 'large', 'extra large']
   * </pre>
   * </li>
   * </ul>
   * @see #store
   * @see #options
   * @see #dataIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-options Original Ext JS documentation of 'options'
   */
  public native function get options():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set options(value:Array):void;

  [ExtConfig]
  /**
   * Specify true to group all items in this list into a single-select
   * radio button group. Defaults to false.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-single Original Ext JS documentation of 'single'
   */
  public native function get single():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set single(value:Boolean):void;

  [ExtConfig]
  /**
   * The →<code>ext.data.Store</code> this list should use as its data source.
   * <p>If neither store nor →<code>options</code> is specified, then the choices list is automatically
   * populated from all unique values of the specified →<code>dataIndex</code> field in the store
   * at first time of filter invocation.</p>
   * @see ext.data.Store
   * @see #options
   * @see #dataIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.List.html#cfg-store Original Ext JS documentation of 'store'
   */
  public native function get store():Store;

  [ExtConfig]
  /**
   * @private
   */
  public native function set store(value:Store):void;

  /**
   * Returns the value of <code>itemDefaults</code>.
   * @see #itemDefaults
   */
  override public native function getItemDefaults():Object;

  /**
   * Sets the value of <code>itemDefaults</code>.
   * @param itemDefaults The new value.
   * @see #itemDefaults
   */
  override public native function setItemDefaults(itemDefaults:Object):void;
}
}