package ext.grid.filters.filter {

[Native("Ext.grid.filters.filter.Number", require)]
/**
 * Filter type for <i>number columns</i> (→<code>ext.grid.column.NumberColumn</code>).
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *       fields: ['id','show'],
 *       data: [
 *           {id: 0, show: 'Battlestar Galactica'},
 *           {id: 1, show: 'Doctor Who'},
 *           {id: 2, show: 'Farscape'},
 *           {id: 3, show: 'Firefly'},
 *           {id: 4, show: 'Star Trek'},
 *           {id: 5, show: 'Star Wars: Christmas Special'}
 *       ]
 *    });
 *
 *   Ext.create('Ext.grid.Panel', {
 *       renderTo: Ext.getBody(),
 *       title: 'Sci-Fi Television',
 *       height: 250,
 *       width: 250,
 *       store: shows,
 *       plugins: {
 *           gridfilters: true
 *       },
 *       columns: [{
 *           dataIndex: 'id',
 *           text: 'ID',
 *           width: 50,
 *           filter: 'number' // May also be 'numeric'
 *       },{
 *           dataIndex: 'show',
 *           text: 'Show',
 *           flex: 1
 *       }]
 *   });
 * </pre>
 * @see ext.grid.column.NumberColumn
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Number.html Original Ext JS documentation of 'Ext.grid.filters.filter.Number'
 */
public class NumberFilter extends TriFilter {
  /**
   * @param config @inheritDoc
   */
  public function NumberFilter(config:NumberFilter = null) {
    super();
  }

  [ExtConfig]
  /**
   * The empty text to show for each field.
   * @default 'Enter Number...'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Number.html#cfg-emptyText Original Ext JS documentation of 'emptyText'
   */
  public native function get emptyText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set emptyText(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Configures field items individually. These properties override those defined
   * by <code>→itemDefaults</code>.
   * <p>Example usage:</p>
   * <pre>
   *  fields: {
   *      // Override itemDefaults for one field:
   *      gt: {
   *          width: 200
   *      }
   *
   *      // "lt" and "eq" fields retain all itemDefaults
   *  },
   * </pre>
   * @default {
   *     gt: {
   *         iconCls: Ext.baseCSSPrefix + 'grid-filters-gt',
   *         margin: '0 0 3px 0'
   *     },
   *     lt: {
   *         iconCls: Ext.baseCSSPrefix + 'grid-filters-lt',
   *         margin: '0 0 3px 0'
   *     },
   *     eq: {
   *         iconCls: Ext.baseCSSPrefix + 'grid-filters-eq',
   *         margin: 0
   *     }
   * }
   * @see #itemDefaults
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.Number.html#cfg-fields Original Ext JS documentation of 'fields'
   * @see #getFields()
   * @see #setFields()
   */
  public native function get fields():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set fields(value:Object):void;

  /**
   * Returns the value of <code>fields</code>.
   * @see #fields
   */
  public native function getFields():Object;

  /**
   * Sets the value of <code>fields</code>.
   * @param fields The new value.
   * @see #fields
   */
  public native function setFields(fields:Object):void;
}
}