package ext.grid.filters.filter {

[Native("Ext.grid.filters.filter.String", require)]
/**
 * The string grid filter allows you to create a filter selection that limits results
 * to values matching a particular string. The filter can be set programmatically or via
 * user input with a configurable <i>text field</i> (→<code>ext.form.field.TextField</code>) in the filter section
 * of the column header.
 * <p>Example String Filter Usage:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var shows = Ext.create('Ext.data.Store', {
 *     fields: ['id','show'],
 *     data: [
 *         {id: 0, show: 'Battlestar Galactica'},
 *         {id: 1, show: 'Doctor Who'},
 *         {id: 2, show: 'Farscape'},
 *         {id: 3, show: 'Firefly'},
 *         {id: 4, show: 'Star Trek'},
 *         {id: 5, show: 'Star Wars: Christmas Special'}
 *     ]
 * });
 *
 * Ext.create('Ext.grid.Panel', {
 *     renderTo: Ext.getBody(),
 *     title: 'Sci-Fi Television',
 *     height: 250,
 *     width: 250,
 *     store: shows,
 *     plugins: {
 *         gridfilters: true
 *     },
 *     columns: [{
 *         dataIndex: 'id',
 *         text: 'ID',
 *         width: 50
 *     },{
 *         dataIndex: 'show',
 *         text: 'Show',
 *         flex: 1,
 *         filter: {
 *             // required configs
 *             type: 'string',
 *             // optional configs
 *             value: 'star',  // setting a value makes the filter active.
 *             itemDefaults: {
 *                 // any Ext.form.field.Text configs accepted
 *             }
 *         }
 *     }]
 * });
 * </pre>
 * @see ext.form.field.TextField
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.String.html Original Ext JS documentation of 'Ext.grid.filters.filter.String'
 */
public class StringFilter extends SingleFilter {
  /**
   * @param config @inheritDoc
   */
  public function StringFilter(config:StringFilter = null) {
    super();
  }

  [ExtConfig]
  /**
   * The empty text to show for each field.
   * @default 'Enter Filter Text...'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.filters.filter.String.html#cfg-emptyText Original Ext JS documentation of 'emptyText'
   */
  public native function get emptyText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set emptyText(value:String):void;
}
}