package ext.grid.header {
import ext.container.Container;
import ext.grid.column.Column;

[Native("Ext.grid.header.Container", require)]
/**
 * @see ext.grid.header.events.HeaderContainer_columnEvent.COLUMN_HIDE
 * @eventType ext.grid.header.events.HeaderContainer_columnEvent.COLUMN_HIDE
 */
[Event(name='onColumnHide', type='ext.grid.header.events.HeaderContainer_columnEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_column_fromIdx_toIdxEvent.COLUMN_MOVE
 * @eventType ext.grid.header.events.HeaderContainer_column_fromIdx_toIdxEvent.COLUMN_MOVE
 */
[Event(name='onColumnMove', type='ext.grid.header.events.HeaderContainer_column_fromIdx_toIdxEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_column_widthEvent.COLUMN_RESIZE
 * @eventType ext.grid.header.events.HeaderContainer_column_widthEvent.COLUMN_RESIZE
 */
[Event(name='onColumnResize', type='ext.grid.header.events.HeaderContainer_column_widthEvent')]
/**
 * @see ext.grid.header.events.HeaderContainerEvent.COLUMNS_CHANGED
 * @eventType ext.grid.header.events.HeaderContainerEvent.COLUMNS_CHANGED
 */
[Event(name='onColumnsChanged', type='ext.grid.header.events.HeaderContainerEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_columnEvent.COLUMNS_HOW
 * @eventType ext.grid.header.events.HeaderContainer_columnEvent.COLUMNS_HOW
 */
[Event(name='onColumnsHow', type='ext.grid.header.events.HeaderContainer_columnEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_column_e_tEvent.HEADER_CLICK
 * @eventType ext.grid.header.events.HeaderContainer_column_e_tEvent.HEADER_CLICK
 */
[Event(name='onHeaderClick', type='ext.grid.header.events.HeaderContainer_column_e_tEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_column_e_tEvent.HEADER_CONTEXT_MENU
 * @eventType ext.grid.header.events.HeaderContainer_column_e_tEvent.HEADER_CONTEXT_MENU
 */
[Event(name='onHeaderContextMenu', type='ext.grid.header.events.HeaderContainer_column_e_tEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_column_e_tEvent.HEADER_TRIGGER_CLICK
 * @eventType ext.grid.header.events.HeaderContainer_column_e_tEvent.HEADER_TRIGGER_CLICK
 */
[Event(name='onHeaderTriggerClick', type='ext.grid.header.events.HeaderContainer_column_e_tEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_menuEvent.MENU_CREATE
 * @eventType ext.grid.header.events.HeaderContainer_menuEvent.MENU_CREATE
 */
[Event(name='onMenuCreate', type='ext.grid.header.events.HeaderContainer_menuEvent')]
/**
 * @see ext.grid.header.events.HeaderContainer_column_directionEvent.SORT_CHANGE
 * @eventType ext.grid.header.events.HeaderContainer_column_directionEvent.SORT_CHANGE
 */
[Event(name='onSortChange', type='ext.grid.header.events.HeaderContainer_column_directionEvent')]
/**
 * Headercontainer is a docked container (<i><code>top</code> or <code>bottom</code> only</i>) that holds the
 * headers (<i>grid columns</i> (→<code>ext.grid.column.Column</code>)) of a
 * <i>grid</i> (→<code>ext.grid.GridPanel</code>) or <i>tree</i> (→<code>ext.tree.TreePanel</code>). The headercontainer
 * handles resizing, moving, and hiding columns. As columns are hidden, moved or
 * resized, the headercontainer triggers changes within the grid or tree's
 * <i>view</i> (→<code>ext.view.TableView</code>). You will not generally need to instantiate this class
 * directly.
 * <p>You may use the
 * →<code>ext.panel.TablePanel.getHeaderContainer()</code>
 * accessor method to access the tree or grid's headercontainer.</p>
 * <p>Grids and trees also have an alias to the two more useful headercontainer methods:</p>
 * <ul>
 * <li><b>→<code>ext.panel.TablePanel.getColumns()</code></b> - aliases
 * →<code>ext.grid.header.HeaderContainer.getGridColumns()</code></li>
 * <li><b>→<code>ext.panel.TablePanel.getVisibleColumns()</code></b> - aliases
 * →<code>ext.grid.header.HeaderContainer.getVisibleGridColumns()</code></li>
 * </ul>
 * @see ext.grid.column.Column
 * @see ext.grid.GridPanel
 * @see ext.tree.TreePanel
 * @see ext.view.TableView
 * @see ext.panel.TablePanel#getHeaderContainer()
 * @see ext.panel.TablePanel#getColumns()
 * @see ext.grid.header.HeaderContainer#getGridColumns()
 * @see ext.panel.TablePanel#getVisibleColumns()
 * @see ext.grid.header.HeaderContainer#getVisibleGridColumns()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html Original Ext JS documentation of 'Ext.grid.header.Container'
 */
public class HeaderContainer extends Container {
  /**
   * @param config @inheritDoc
   */
  public function HeaderContainer(config:HeaderContainer = null) {
    super();
  }

  [ExtConfig]
  /**
   * The text for the columns submenu item.
   * @default 'Columns'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-columnsText Original Ext JS documentation of 'columnsText'
   */
  public native function get columnsText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set columnsText(value:String):void;

  [ExtConfig]
  /**
   * Width of the header if no width or flex is specified.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-defaultWidth Original Ext JS documentation of 'defaultWidth'
   */
  public native function get defaultWidth():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set defaultWidth(value:Number):void;

  [ExtConfig]
  /**
   * False to disable column hiding within this grid.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-enableColumnHide Original Ext JS documentation of 'enableColumnHide'
   */
  public native function get enableColumnHide():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableColumnHide(value:Boolean):void;

  /**
   * True if this HeaderContainer is in fact a group header which contains sub headers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#property-isGroupHeader Original Ext JS documentation of 'isGroupHeader'
   */
  public native function get isGroupHeader():Boolean;

  /**
   * @private
   */
  public native function set isGroupHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to constrain column dragging so that a column cannot be dragged into
   * or out of this column.
   * <p><b>Note that this config is only valid for column headers which contain child column headers,
   * eg:</b>
   * {
   * sealed: true
   * text: 'ExtJS',
   * columns: [{
   * text: '3.0.4',
   * dataIndex: 'ext304'
   * }, {
   * text: '4.1.0',
   * dataIndex: 'ext410'
   * }
   * }</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-sealed Original Ext JS documentation of 'sealed'
   */
  public native function get sealed():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sealed(value:Boolean):void;

  [ExtConfig]
  /**
   * The text to display in the sort menu to sort items in ascending order.
   * @default 'Sort Ascending'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-sortAscText Original Ext JS documentation of 'sortAscText'
   */
  public native function get sortAscText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortAscText(value:String):void;

  [ExtConfig]
  /**
   * The text to display in the sort menu to clear the sort order.
   * @default 'Clear Sort'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-sortClearText Original Ext JS documentation of 'sortClearText'
   */
  public native function get sortClearText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortClearText(value:String):void;

  [ExtConfig]
  /**
   * The text to display in the sort menu to sort items in descending order.
   * @default 'Sort Descending'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-sortDescText Original Ext JS documentation of 'sortDescText'
   */
  public native function get sortDescText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortDescText(value:String):void;

  [ExtConfig]
  /**
   * Provides the default sortable state for all Headers within this HeaderContainer.
   * Also turns on or off the menus in the HeaderContainer. Note that the menu is
   * shared across every header and therefore turning it off will remove the menu
   * items for every header.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-sortable Original Ext JS documentation of 'sortable'
   */
  public native function get sortable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set sortable(value:Boolean):void;

  [ExtConfig]
  /**
   * HeaderContainer overrides the default weight of 0 for all docked items to 100.
   * This is so that it has more priority over things like toolbars.
   * @default 100
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#cfg-weight Original Ext JS documentation of 'weight'
   * @see #setWeight()
   */
  override public native function get weight():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set weight(value:Number):void;

  /**
   * Returns the number of <b>grid columns</b> descended from this HeaderContainer.
   * Group Columns are HeaderContainers. All grid columns are returned, including hidden ones.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getColumnCount Original Ext JS documentation of 'getColumnCount'
   */
  public native function getColumnCount():uint;

  /**
   * Returns an array of menu CheckItems corresponding to all immediate children
   * of the passed Container which have been configured as hideable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getColumnMenu Original Ext JS documentation of 'getColumnMenu'
   */
  public native function getColumnMenu(headerContainer:*):Array;

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * Returns an array of all columns which exist in the grid's View, visible or not.
   * This goes down to the leaf column header level, and does not return <b>grouped</b>
   * headers which contain sub headers.
   * <p>It includes hidden headers even though they are not rendered. This is for
   * collection of menu items for the column hide/show menu.</p>
   * <p>Headers which have a hidden ancestor have a <code>hiddenAncestor: true</code> property
   * injected so that descendants are known to be hidden without interrogating that
   * header's ownerCt axis for a hidden ancestor.</p>
   * <p>See also →<code>ext.grid.header.HeaderContainer.getVisibleGridColumns()</code></p>
   * @return columns An array of columns. Returns an
   * empty array if no columns are found.
   * @see ext.grid.header.HeaderContainer#getVisibleGridColumns()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getGridColumns Original Ext JS documentation of 'getGridColumns'
   */
  public native function getGridColumns():Array;

  /**
   * Get a leaf level header by index regardless of what the nesting
   * structure is.
   * @param index The column index for which to retrieve the column.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getHeaderAtIndex Original Ext JS documentation of 'getHeaderAtIndex'
   */
  public native function getHeaderAtIndex(index:Number):Column;

  /**
   * Returns the index of a leaf level header regardless of what the nesting
   * structure is.
   * <p>If a group header is passed, the index of the first leaf level header within it is returned.</p>
   * @param header The header to find the index of
   * @return The index of the specified column header
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getHeaderIndex Original Ext JS documentation of 'getHeaderIndex'
   */
  public native function getHeaderIndex(header:Column):Number;

  /**
   * Returns an array of menu items to be placed into the shared menu
   * across all headers in this header container.
   * @return menuItems
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getMenuItems Original Ext JS documentation of 'getMenuItems'
   */
  public native function getMenuItems():Array;

  /**
   * Gets the full width of all columns that are visible for setting width of tables.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getTableWidth Original Ext JS documentation of 'getTableWidth'
   */
  public native function getTableWidth():uint;

  [ArrayElementType("ext.grid.column.Column")]
  /**
   * Returns an array of the <b>visible</b> columns in the grid. This goes down to the
   * lowest column header level, and does not return <b>grouped</b> headers which contain
   * sub headers.
   * <p>See also →<code>ext.grid.header.HeaderContainer.getGridColumns()</code></p>
   * @return columns An array of visible columns. Returns
   * an empty array if no visible columns are found.
   * @see ext.grid.header.HeaderContainer#getGridColumns()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getVisibleGridColumns Original Ext JS documentation of 'getVisibleGridColumns'
   */
  public native function getVisibleGridColumns():Array;

  /**
   * When passed a column index, returns the closet <i>visible</i> column to that. If the column
   * at the passed index is visible, that is returned. If it is hidden, either the next visible,
   * or the previous visible column is returned.
   * @param index Position at which to find the closest visible column.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-getVisibleHeaderClosestToIndex Original Ext JS documentation of 'getVisibleHeaderClosestToIndex'
   */
  public native function getVisibleHeaderClosestToIndex(index:Number):Column;

  /**
   * Returns the column's sealed status.
   * @since 6.5.0
   * @return <code>true</code> if this column is sealed, <code>false</code> otherwise.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#method-isSealed Original Ext JS documentation of 'isSealed'
   */
  public native function isSealed():Boolean;
}
}