package ext.grid.header.events {
import ext.grid.column.Column;
import ext.grid.header.HeaderContainer;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.grid.header.events.HeaderContainer_columnEvent")]
public class HeaderContainer_columnEvent extends FlExtEvent {
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#event-columnshow Original Ext JS documentation of 'columnshow'
   * @see ext.grid.header.HeaderContainer
   * @eventType onColumnsHow
   */
  public static const COLUMNS_HOW:String = "onColumnsHow";
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.header.Container.html#event-columnhide Original Ext JS documentation of 'columnhide'
   * @see ext.grid.header.HeaderContainer
   * @eventType onColumnHide
   */
  public static const COLUMN_HIDE:String = "onColumnHide";
  public static const __PARAMETER_SEQUENCE__:Array = ["ct", "column", "eOpts"];

  public function HeaderContainer_columnEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The Column header Component which provides
   * the column definition
   */
  public native function get column():Column;

  /**
   * The grid's header Container which encapsulates
   * all column headers.
   */
  public native function get ct():HeaderContainer;
}
}