package ext.grid.locking {

[Mixin("ext.grid.locking.Lockable")]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Lockable is a private mixin which injects lockable behavior into any
 * TablePanel subclass such as GridPanel or TreePanel. TablePanel will
 * automatically inject the Ext.grid.locking.Lockable mixin in when one of the
 * these conditions are met:</p>
 * <ul>
 * <li>The TablePanel has the lockable configuration set to true</li>
 * <li>One of the columns in the TablePanel has locked set to true/false</li>
 * </ul>
 * <p>Each TablePanel subclass must register an alias. It should have an array
 * of configurations to copy to the 2 separate tablepanels that will be generated
 * to note what configurations should be copied. These are named normalCfgCopy and
 * lockedCfgCopy respectively.</p>
 * <p>Configurations which are specified in this class will be available on any grid or
 * tree which is using the lockable functionality.</p>
 * <p>By default the two grids, "locked" and "normal" will be arranged using an
 * <i>hbox</i> (→<code>ext.layout.container.HBoxLayout</code>) layout. If the lockable grid is configured with
 * <code>split:true (→split)</code>, a vertical splitter will be placed between the two grids
 * to resize them.</p>
 * <p>It is possible to override the layout of the lockable grid, or example, you may wish to
 * use a border layout and have one of the grids collapsible.</p>
 * @see ext.layout.container.HBoxLayout
 * @see ext.grid.locking.Lockable#split
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html Original Ext JS documentation of 'Ext.grid.locking.Lockable'
 * @see ext.grid.locking.Lockable
 */
public interface ILockable {
  [ExtConfig] /**
   * By default, a lockable grid uses an →<code>ext.layout.container.HBoxLayout</code> layout to arrange
   * the two grids (possibly separated by a splitter).
   * <p>Using this config it is possible to specify a different layout to arrange the two grids.</p>
   * @see ext.layout.container.HBoxLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-layout Original Ext JS documentation of 'layout'
   */
  function get layout():*;

  [ExtConfig] function set layout(value:*):void;

  [ExtConfig] /**
   * The text to display on the column menu to lock a column.
   * @default 'Lock'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockText Original Ext JS documentation of 'lockText'
   */
  function get lockText():String;

  [ExtConfig] function set lockText(value:String):void;

  [ExtConfig] /**
   * Any special configuration options for the locked part of the grid
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockedGridConfig Original Ext JS documentation of 'lockedGridConfig'
   */
  function get lockedGridConfig():Object;

  [ExtConfig] function set lockedGridConfig(value:Object):void;

  [ExtConfig] /**
   * A view configuration to be applied to the locked side of the grid. Any conflicting
   * configurations between lockedViewConfig and viewConfig will be overwritten by the
   * lockedViewConfig.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockedViewConfig Original Ext JS documentation of 'lockedViewConfig'
   */
  function get lockedViewConfig():Object;

  [ExtConfig] function set lockedViewConfig(value:Object):void;

  [ExtConfig] /**
   * Any special configuration options for the normal part of the grid
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-normalGridConfig Original Ext JS documentation of 'normalGridConfig'
   */
  function get normalGridConfig():Object;

  [ExtConfig] function set normalGridConfig(value:Object):void;

  [ExtConfig] /**
   * A view configuration to be applied to the normal/unlocked side of the grid. Any
   * conflicting configurations between normalViewConfig and viewConfig will be
   * overwritten by the normalViewConfig.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-normalViewConfig Original Ext JS documentation of 'normalViewConfig'
   */
  function get normalViewConfig():Object;

  [ExtConfig] function set normalViewConfig(value:Object):void;

  [ExtConfig] /**
   * Configure as <code>true</code> to place a resizing <i>splitter</i> (→<code>ext.resizer.Splitter</code>)
   * between the locked and unlocked columns. May also be a configuration object for the Splitter.
   * @default false
   * @see ext.resizer.Splitter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-split Original Ext JS documentation of 'split'
   */
  function get split():*;

  [ExtConfig] function set split(value:*):void;

  [ArrayElementType("String")]
  [ExtConfig] /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.
   * Adds the following stateEvents:</p>
   * <ul>
   * <li>→<code>event:onLockColumn</code></li>
   * <li>→<code>event:onUnlockColumn</code></li>
   * </ul>
   * @see #stateEvents
   * @see #stateful
   * @see #event:onLockColumn
   * @see #event:onUnlockColumn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  function get stateEvents():Array;

  [ExtConfig] function set stateEvents(value:Array):void;

  [ExtConfig] /**
   * The xtype of the subgrid to specify. If this is not specified lockable will
   * determine the subgrid xtype to create by the following rule. Use the superclasses
   * xtype if the superclass is NOT tablepanel, otherwise use the xtype itself.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-subGridXType Original Ext JS documentation of 'subGridXType'
   */
  function get subGridXType():String;

  [ExtConfig] function set subGridXType(value:String):void;

  [ExtConfig] /**
   * Synchronize rowHeight between the normal and locked grid view. This is turned on
   * by default. If your grid is guaranteed to have rows of all the same height, you
   * should set this to false to optimize performance.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-syncRowHeight Original Ext JS documentation of 'syncRowHeight'
   */
  function get syncRowHeight():Boolean;

  [ExtConfig] function set syncRowHeight(value:Boolean):void;

  [ExtConfig] /**
   * The text to display on the column menu to unlock a column.
   * @default 'Unlock'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-unlockText Original Ext JS documentation of 'unlockText'
   */
  function get unlockText():String;

  [ExtConfig] function set unlockText(value:String):void;

  /**
   * Synchronizes the row heights between the locked and non locked portion of the grid for each
   * row. If one row is smaller than the other, the height will be increased to match
   * the larger one.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#method-syncRowHeights Original Ext JS documentation of 'syncRowHeights'
   */
  function syncRowHeights():void;
}
}