package ext.grid.locking {
import ext.Base;

[Native("Ext.grid.locking.Lockable", require)]
/**
 * @see ext.grid.locking.events.Lockable_store_operationEvent.BEFORE_LOAD
 * @eventType ext.grid.locking.events.Lockable_store_operationEvent.BEFORE_LOAD
 */
[Event(name='onBeforeLoad', type='ext.grid.locking.events.Lockable_store_operationEvent')]
/**
 * @see ext.grid.locking.events.Lockable_store_filtersEvent.FILTER_CHANGE
 * @eventType ext.grid.locking.events.Lockable_store_filtersEvent.FILTER_CHANGE
 */
[Event(name='onFilterChange', type='ext.grid.locking.events.Lockable_store_filtersEvent')]
/**
 * @see ext.grid.locking.events.Lockable_store_grouperEvent.GROUP_CHANGE
 * @eventType ext.grid.locking.events.Lockable_store_grouperEvent.GROUP_CHANGE
 */
[Event(name='onGroupChange', type='ext.grid.locking.events.Lockable_store_grouperEvent')]
/**
 * @see ext.grid.locking.events.Lockable_records_successful_operationEvent.LOAD
 * @eventType ext.grid.locking.events.Lockable_records_successful_operationEvent.LOAD
 */
[Event(name='onLoad', type='ext.grid.locking.events.Lockable_records_successful_operationEvent')]
/**
 * @see ext.grid.locking.events.Lockable_columnEvent.LOCK_COLUMN
 * @eventType ext.grid.locking.events.Lockable_columnEvent.LOCK_COLUMN
 */
[Event(name='onLockColumn', type='ext.grid.locking.events.Lockable_columnEvent')]
/**
 * @see ext.grid.locking.events.Lockable_lockedColumns_normalColumnsEvent.PROCESS_COLUMNS
 * @eventType ext.grid.locking.events.Lockable_lockedColumns_normalColumnsEvent.PROCESS_COLUMNS
 */
[Event(name='onProcessColumns', type='ext.grid.locking.events.Lockable_lockedColumns_normalColumnsEvent')]
/**
 * @see ext.grid.locking.events.Lockable_columnEvent.UNLOCK_COLUMN
 * @eventType ext.grid.locking.events.Lockable_columnEvent.UNLOCK_COLUMN
 */
[Event(name='onUnlockColumn', type='ext.grid.locking.events.Lockable_columnEvent')]
/**
 * @see ext.grid.locking.events.LockableEvent.VIEW_READY
 * @eventType ext.grid.locking.events.LockableEvent.VIEW_READY
 */
[Event(name='onViewReady', type='ext.grid.locking.events.LockableEvent')]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Lockable is a private mixin which injects lockable behavior into any
 * TablePanel subclass such as GridPanel or TreePanel. TablePanel will
 * automatically inject the Ext.grid.locking.Lockable mixin in when one of the
 * these conditions are met:</p>
 * <ul>
 * <li>The TablePanel has the lockable configuration set to true</li>
 * <li>One of the columns in the TablePanel has locked set to true/false</li>
 * </ul>
 * <p>Each TablePanel subclass must register an alias. It should have an array
 * of configurations to copy to the 2 separate tablepanels that will be generated
 * to note what configurations should be copied. These are named normalCfgCopy and
 * lockedCfgCopy respectively.</p>
 * <p>Configurations which are specified in this class will be available on any grid or
 * tree which is using the lockable functionality.</p>
 * <p>By default the two grids, "locked" and "normal" will be arranged using an
 * <i>hbox</i> (→<code>ext.layout.container.HBoxLayout</code>) layout. If the lockable grid is configured with
 * <code>split:true (→split)</code>, a vertical splitter will be placed between the two grids
 * to resize them.</p>
 * <p>It is possible to override the layout of the lockable grid, or example, you may wish to
 * use a border layout and have one of the grids collapsible.</p>
 * @see ext.layout.container.HBoxLayout
 * @see #split
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html Original Ext JS documentation of 'Ext.grid.locking.Lockable'
 */
public class Lockable extends Base implements ILockable {
  /**
   * @param config @inheritDoc
   */
  public function Lockable(config:Lockable = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, a lockable grid uses an →<code>ext.layout.container.HBoxLayout</code> layout to arrange
   * the two grids (possibly separated by a splitter).
   * <p>Using this config it is possible to specify a different layout to arrange the two grids.</p>
   * @see ext.layout.container.HBoxLayout
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-layout Original Ext JS documentation of 'layout'
   */
  public native function get layout():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set layout(value:*):void;

  [ExtConfig]
  /**
   * The text to display on the column menu to lock a column.
   * @default 'Lock'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockText Original Ext JS documentation of 'lockText'
   */
  public native function get lockText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockText(value:String):void;

  [ExtConfig]
  /**
   * Any special configuration options for the locked part of the grid
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockedGridConfig Original Ext JS documentation of 'lockedGridConfig'
   */
  public native function get lockedGridConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockedGridConfig(value:Object):void;

  [ExtConfig]
  /**
   * A view configuration to be applied to the locked side of the grid. Any conflicting
   * configurations between lockedViewConfig and viewConfig will be overwritten by the
   * lockedViewConfig.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-lockedViewConfig Original Ext JS documentation of 'lockedViewConfig'
   */
  public native function get lockedViewConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lockedViewConfig(value:Object):void;

  [ExtConfig]
  /**
   * Any special configuration options for the normal part of the grid
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-normalGridConfig Original Ext JS documentation of 'normalGridConfig'
   */
  public native function get normalGridConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set normalGridConfig(value:Object):void;

  [ExtConfig]
  /**
   * A view configuration to be applied to the normal/unlocked side of the grid. Any
   * conflicting configurations between normalViewConfig and viewConfig will be
   * overwritten by the normalViewConfig.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-normalViewConfig Original Ext JS documentation of 'normalViewConfig'
   */
  public native function get normalViewConfig():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set normalViewConfig(value:Object):void;

  [ExtConfig]
  /**
   * Configure as <code>true</code> to place a resizing <i>splitter</i> (→<code>ext.resizer.Splitter</code>)
   * between the locked and unlocked columns. May also be a configuration object for the Splitter.
   * @default false
   * @see ext.resizer.Splitter
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-split Original Ext JS documentation of 'split'
   */
  public native function get split():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set split(value:*):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.
   * Adds the following stateEvents:</p>
   * <ul>
   * <li>→<code>event:onLockColumn</code></li>
   * <li>→<code>event:onUnlockColumn</code></li>
   * </ul>
   * @see #stateEvents
   * @see #stateful
   * @see #event:onLockColumn
   * @see #event:onUnlockColumn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  public native function get stateEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stateEvents(value:Array):void;

  [ExtConfig]
  /**
   * The xtype of the subgrid to specify. If this is not specified lockable will
   * determine the subgrid xtype to create by the following rule. Use the superclasses
   * xtype if the superclass is NOT tablepanel, otherwise use the xtype itself.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-subGridXType Original Ext JS documentation of 'subGridXType'
   */
  public native function get subGridXType():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set subGridXType(value:String):void;

  [ExtConfig]
  /**
   * Synchronize rowHeight between the normal and locked grid view. This is turned on
   * by default. If your grid is guaranteed to have rows of all the same height, you
   * should set this to false to optimize performance.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-syncRowHeight Original Ext JS documentation of 'syncRowHeight'
   */
  public native function get syncRowHeight():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set syncRowHeight(value:Boolean):void;

  [ExtConfig]
  /**
   * The text to display on the column menu to unlock a column.
   * @default 'Unlock'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#cfg-unlockText Original Ext JS documentation of 'unlockText'
   */
  public native function get unlockText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set unlockText(value:String):void;

  /**
   * Synchronizes the row heights between the locked and non locked portion of the grid for each
   * row. If one row is smaller than the other, the height will be increased to match
   * the larger one.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#method-syncRowHeights Original Ext JS documentation of 'syncRowHeights'
   */
  public native function syncRowHeights():void;
}
}