package ext.grid.locking.events {
import ext.grid.GridPanel;
import ext.grid.column.Column;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.grid.locking.events.Lockable_columnEvent")]
public class Lockable_columnEvent extends FlExtEvent {
  /**
   * Fires when a column is locked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#event-lockcolumn Original Ext JS documentation of 'lockcolumn'
   * @see ext.grid.locking.Lockable
   * @eventType onLockColumn
   */
  public static const LOCK_COLUMN:String = "onLockColumn";
  /**
   * Fires when a column is unlocked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.grid.locking.Lockable.html#event-unlockcolumn Original Ext JS documentation of 'unlockcolumn'
   * @see ext.grid.locking.Lockable
   * @eventType onUnlockColumn
   */
  public static const UNLOCK_COLUMN:String = "onUnlockColumn";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "column", "eOpts"];

  public function Lockable_columnEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The column being locked.
   */
  public native function get column():Column;

  /**
   * The gridpanel.
   */
  public native function get source():GridPanel;
}
}